/* TWEAK DOM SELECTOR */
// (c) salt.js @https://github.com/james2doyle
"use strict";
console.log('polyfills.js');

window._s = function(selector, context, undefined) {
    var matches = {
        "#": "getElementById",
        ".": "getElementsByClassName",
        "@": "getElementsByName",
        "=": "getElementsByTagName",
        "*": "querySelectorAll"
    } [selector[0]];
    var el = (context === undefined ? document : context)[matches](selector.slice(1));
    return el.length < 2 ? el[0] : el;
};

window.Element.prototype.attr = function(name, value) {
    if (value) {
        this.setAttribute(name, value);
        return this;
    } else {
        return this.getAttribute(name);
    }
};

window.Element.prototype.on = function(eventType, callback) {
    eventType = eventType.split(" ");

    for (var i = 0; i < eventType.length; i++) {
        this.addEventListener(eventType[i], callback);
    }

    return this;
};

window.NodeList.prototype.on = function(eventType, callback) {
    this.each(function(el) {
        el.on(eventType, callback);
    });
    return this;
};

window.HTMLCollection.prototype.on = function(eventType, callback) {
    Array.from(this).forEach(function(el) {
        el.on(eventType, callback);
    });
};

window.Element.prototype.hasClass = function(name) {
    return this.classList.contains(name);
}; // _s().addClass('name');


window.NodeList.prototype.addClass = function(name) {
    this.each(function(el) {
        el.classList.add(name);
    });
    return this;
};

window.Element.prototype.addClass = function(name) {
    this.classList.add(name);
    return this;
};

window.HTMLCollection.prototype.addClass = function(name) {
    Array.from(this).forEach(function(el) {
        el.classList.add(name);
    });
}; // _s().removeClass('name');


window.NodeList.prototype.removeClass = function(name) {
    this.each(function(el) {
        el.classList.remove(name);
    });
    return this;
};

window.Element.prototype.removeClass = function(name) {
    this.classList.remove(name);
    return this;
};

window.HTMLCollection.prototype.removeClass = function(name) {
    Array.from(this).forEach(function(el) {
        el.classList.remove(name);
    });
};


window.Element.prototype.fadeOut = function(name) {
    this.classList.add('fade-out');
    return this;
};


document.getCookie = function(a) {
    var b = document.cookie.match('(^|;)\\s*' + a + '\\s*=\\s*([^;]+)');
    return b ? b.pop() : '';
}

// Set a Cookie
function setCookie(cName, cValue, expDays) {
        let date = new Date();
        date.setTime(date.getTime() + (expDays * 24 * 60 * 60 * 1000));
        const expires = "expires=" + date.toUTCString();
        document.cookie = cName + "=" + cValue + "; " + expires + "; path=/";
}
// Apply setCookie
// setCookie('username', username, 30);


Array.prototype.remove = function() {
    var what, a = arguments,
        L = a.length,
        ax;
    while (L && this.length) {
        what = a[--L];
        while ((ax = this.indexOf(what)) !== -1) {
            this.splice(ax, 1);
        }
    }
    return this;
};


Object.defineProperty(Array.prototype, 'chunk', {
    value: function(chunkSize) {
        var R = [];
        for (var i = 0; i < this.length; i += chunkSize)
            R.push(this.slice(i, i + chunkSize));
        return R;
    }
});

String.prototype.isEmpty = function() {
  return this.trim().length == 0 ? true : false;
}

String.prototype.containsNumber = function() {
  return /\d/.test(this);
}

String.prototype.containsCapital = function() {
  return /[A-Z]/.test(this);
}

String.prototype.containsLower = function() {
  return /[a-z]/.test(this);
}

String.prototype.isEmailFormat = function() {
    // const re = /^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    // return re.test(String(this).toLowerCase());
    return /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(String(this).toLowerCase())
}

String.prototype.isPhoneFormat = function() {
    var output = false;
    if (this.trim().length > 9) {
        output = true;
    }

    if (output && /^\d+$/.test(this)) {
        output = true;
    } else {
        output = false;
    }
    return output;
}

/* Numeric 
setInputFilter(el, function (value) {
  return /^\d*\.?\d*$/.test(value);
});
*/
function setInputFilter(textbox, inputFilter) {
    ["input", "keydown", "keyup", "mousedown", "mouseup", "select", "contextmenu", "drop"].forEach(function(event) {
        textbox.addEventListener(event, function() {
            if (inputFilter(this.value)) {
                this.oldValue = this.value;
                this.oldSelectionStart = this.selectionStart;
                this.oldSelectionEnd = this.selectionEnd;
            } else if (this.hasOwnProperty("oldValue")) {
                this.value = this.oldValue;
                this.setSelectionRange(this.oldSelectionStart, this.oldSelectionEnd);
            } else {
                this.value = "";
            }
        });
    });
}


function setInputFilterWithMaxLength(textbox, inputFilter, maxLength) {
    ["input", "keydown", "keyup", "mousedown", "mouseup", "select", "contextmenu", "drop"].forEach(function(event) {
        textbox.addEventListener(event, function() {
            if (inputFilter(this.value)) {
                if(this.value.length <= maxLength) {
                    this.oldValue = this.value;
                    this.oldSelectionStart = this.selectionStart;
                    this.oldSelectionEnd = this.selectionEnd;
                } else {
                    this.value = this.oldValue;
                }
            } else if (this.hasOwnProperty("oldValue")) {
                this.value = this.oldValue;
                this.setSelectionRange(this.oldSelectionStart, this.oldSelectionEnd);
            } else {
                this.value = "";
            }
        });
    });
}

