<?php

use MainWordpress\ThemeFood\Utils;
use MainWordpress\ThemeFood\Settings;
use Twig\Environment;
use Twig\Lexer;
use Twig\Extension\StringLoaderExtension;
use Twig\Loader\FilesystemLoader;


function mtf_utils() {
	return Utils::instance();
}

function mtf_asset($path) {
	return Utils::instance()->asset($path);
}

function mtf_filter_price($price) {
    $currency = apply_filters( 'mtf/currency_symbol', 'Rp' );
    return sprintf('%s%s', $currency, number_format( $price, 0, ',', '.' ) );
}


function mtf_filter_phone_number($phone) {
	if (!empty($phone)) {
    	$phone = preg_replace('/[^0-9.]+/', '', $phone);
        if (substr($phone, 0, 2) == '08') {
            $phone = '628' . substr($phone, 2);
        }
    }
    return $phone;
}

function mtf_get_admin_phones() {
    $input_admin_phone = maybe_unserialize(get_option('mtf_admin_phones', []));
    $output = [];
    if (is_array($input_admin_phone)) {
        $output = $input_admin_phone;
    }
    if (is_string($input_admin_phone)) {
        $output[] = $input_admin_phone;
    }
    $output = apply_filters(
                'mtf/admin_phones',
                $output
            );

    foreach($output as $key => $value) {
        $output[$key] = mtf_filter_phone_number($value);
    } 
    return $output;
}

function mtf_get_setting($key) {
    $settings = Settings::instance();
    return $settings->{$key} ?? null;
}

if ( ! function_exists( 'mtf_parse_template' ) ) {
    function  mtf_parse_template( $template, $data ) {
        $loader = new FilesystemLoader( MTF_PLUGIN_DIR . 'inc/resources/template' );
        $twig   = new Environment( $loader );
        $twig->addExtension(new StringLoaderExtension());
        $lexer = new Lexer($twig, [
            'tag_comment'   => ['{#', '#}'],
            'tag_block'     => ['{%', '%}'],
            'tag_variable'  => ['{', '}'],
            'interpolation' => ['#{', '}'],
        ]);
        $twig->setLexer($lexer);
        $engine = twig_template_from_string( $twig, $template);
        return $engine->render( $data );
    }
}