<?php
/**
 * Plugin Name:     KirimWa ThemeFood
 * Plugin URI:      https://mainwordpress.com/plugin/kirimwa-themefood/
 * Description:     Integrasi KirimWa dengan template ThemeFood
 * Author:          M Ali
 * Author URI:      https://mainwordpress.com
 * Text Domain:     kirimwa-themefood
 * Version:         0.3.0
 *
 * @package         Kirimwa_ThemeFood
 */

define( 'MTF_DIR', __DIR__ );
define( 'MTF_VERSION', '0.3.0' );
define( 'MTF_BUILD_VERSION', 25 );
define( 'MTF_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'MTF_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'MTF_DB_LOCATION', plugin_dir_url( __FILE__ ) );

require_once MTF_PLUGIN_DIR . 'inc/bootstrap.php';

add_action( 'admin_menu', 'mtf_action_admin_menu' );
function mtf_action_admin_menu() {
        $page_title = __('KirimWa', 'mtf');
        $menu_title = __('KirimWa', 'mtf');
        $capability = 'manage_options';
        $menu_slug  = 'mtf';
        $function   =  'mtf_action_admin_menu_content';
        $icon_url   = 'dashicons-schedule';
        $position   = 2;

        add_menu_page( $page_title, $menu_title,  $capability,  $menu_slug,  $function,  $icon_url,  $position );

}

function mtf_action_admin_menu_content() {

        global $wp_version;

        $key = ot_get_option( 'token_key' );    
        $api = ot_get_option( 'bot_service' );

        $is_kirimwa = preg_match( '#kirimwa_adapter#', $api );

        $adapter = get_option('mtf_adapter', 'wpajax');

        if (@$_POST['mtf_api_url']) {
            $serial = filter_input( INPUT_POST, 'mtf_serial', FILTER_SANITIZE_SPECIAL_CHARS);
            $url = filter_input( INPUT_POST, 'mtf_api_url', FILTER_VALIDATE_URL);
            $admin_phone = filter_input( INPUT_POST, 'mtf_admin_phones', FILTER_SANITIZE_SPECIAL_CHARS);
            $adapter = filter_input( INPUT_POST, 'mtf_adapter', FILTER_SANITIZE_SPECIAL_CHARS);

            if ($url) {
                update_option('mtf_api_url', $url);
            }

            if ($serial) {
                update_option('mtf_serial', $serial);
            }

            if ($admin_phone) {
                update_option('mtf_admin_phones', $admin_phone);
            } else {
                update_option('mtf_admin_phones', '');
            }

            if ($adapter) {
                $adapter = $adapter == 'standalone' ? 'standalone' : 'wpajax';
                update_option('mtf_adapter', $adapter);
            }
        }

        $adapter_url = get_option('kirimwa_url_adapter', admin_url() .'admin-ajax.php?action=kirimwa_adapter' );

        if ($adapter == 'standalone') {
            $api_url = get_option('mtf_api_url', '');
            $api_key = ot_get_option( 'token_key' );

            $adapter_url = plugin_dir_url( __FILE__ ) . 'adapter.php?mode=text&_key='.$api_key.'&_url='.$api_url;
        }
                

        ?>
        <div class="wrap">
            <style type="text/css">
                .badge {
                    border-radius: 3px;
                    text-transform: uppercase;
                    letter-spacing: 1px;
                    font-size: 12px;
                    padding: 4px 8px;
                    color:  rgba(255, 255, 255, 0.9);
                }

                .badge.success {
                    background-color: green;
                }

                .badge.danger {
                    background-color: red;
                }


                @media(min-width:  765px) {
                    .kirimwa-themefood-form input {
                        min-width: 350px;
                    }
                }
            </style>
            <h1>Pengaturan KirimWa</h1>
            <form action="<?php echo admin_url() . 'admin.php?page=mtf'; ?>" method="post" class="kirimwa-themefood-form">
                <input type="hidden" name="mtf_nonce" id="mtf-nonce" value="<?php echo wp_create_nonce(); ?>">
                <input type="hidden" name="mtf_nonce" id="mtf-api-token" value="<?php echo $key; ?>">
                <input type="hidden" name="mtf_nonce" id="mtf-api-test-url" value="<?php echo $adapter_url; ?>">
                <table class="form-table" role="presentation">
                    <tbody>
                        <tr>
                            <th scope="row"><label for="mtf-api-url">Status</label></th>
                            <td>
                                <?php if ($is_kirimwa): ?>
                                    <span class="badge success">Aktif</span>
                                <?php else: ?>
                                    <span class="badge danger">Non aktif</span>
                                <?php endif; ?>
                                <p class="description">Silahkan memilih opsi <code>KirimWa</code> di <a href="<?php echo admin_url('/admin.php?page=themefood-options#section_follow_up'); ?>">pengaturan ThemeFood</a></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="mtf-api-adapter">Adapter</label></th>
                            <td>
                               <select name="mtf_adapter" id="mtf-api-adapter">
                                   <option value="">Pilihan adapter</option>
                                   <option value="wpajax"<?php echo ($adapter == 'wpajax' ? ' selected' : ''); ?>>WP Ajax</option>
                                   <option value="standalone"<?php echo ($adapter == 'standalone' ? ' selected' : '');?>>Standalone</option>
                               </select>
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row"><label for="mtf-api-url">API URl</label></th>
                            <td>
                                <input type="text" id="mtf-api-url" name="mtf_api_url" placeholder="Api URL" value="<?php echo get_option('mtf_api_url', ''); ?>">
                            </td>
                        </tr>
                        
                        <tr>
                            <th scope="row"><label for="mtf-api-key">API Key</label></th>
                            <td>
                                <div id="mtf-api-key"><?php echo $key; ?></div>
                                <p class="description">Setting api key di <a href="<?php echo admin_url('/admin.php?page=themefood-options#section_follow_up'); ?>">halaman ini</a>.</p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row"><label for="mtf-nomor-admin">Nomor Admin</label></th>
                            <td>
                                <input type="text" id="mtf-nomor-admin" name="mtf_admin_phones" placeholder="62xxxxxx" value="<?php echo get_option('mtf_admin_phones', ''); ?>">
                                <p class="description">Gunakan format internasional. Contoh: 6281200000001</p>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <p>
                    <button class="button button-primary">Submit</button>
                    <a href="#" id="mtf-btn-test" class="button">Test kirim pesan</a>
                </p>
            </form>

            <script type="text/javascript">
                var test_btn = document.getElementById('mtf-btn-test');
                if (test_btn !== null) {
                    test_btn.onclick = function() {
                        console.log('Test kirimwa');
                        var server = document.getElementById('mtf-api-test-url').value;
                        var nonce = document.getElementById('mtf-nonce').value;
                        var message = `Test koneksi whatsapp. ${window.location.hostname}`;

                        test_btn.innerHTML = 'Loading';
                        server += '&output=json';

                        jQuery.ajax({
                            type : "post",
                            dataType : "json",
                            url : server,
                            data : JSON.stringify({phone_no: '6289508618321', message : message, nonce: nonce}),
                            success: function(response) {
                                test_btn.innerHTML = 'Test kirim pesan';
                                console.log(response);
                                if(response.code == 200) {
                                    alert("Berhasil");
                                }
                                else {
                                    alert("Your data could not be added");
                                }
                            },
                        });  
                    };
                }
            </script>
        </div>
        <?php
      
}



add_action( 'wp_ajax_kirimwa_adapter', 'ajax_kirimwa_adapter' );
add_action( 'wp_ajax_nopriv_kirimwa_adapter', 'ajax_kirimwa_adapter' );

function ajax_kirimwa_adapter() {
    $json = file_get_contents('php://input');
    $data = json_decode($json);

    if (json_last_error() == JSON_ERROR_NONE) {
        update_option('_kirimwa_temp_bucket', $json);

        $requestParam  = [
                        'phone'     => str_replace('+', '', $data->phone_no),
                        'message'   => $data->message,
                        'type'      => 'text',
                ];

        $key = ot_get_option( 'token_key' );    
        $api = ot_get_option( 'bot_service' );

        $write = sprintf("Phone: %s|api: %s", $json, $api);

        $remote_url = apply_filters( 'mtf/sender_api_url', get_option('mtf_api_url', $api) );
        $token      = apply_filters( 'mtf/sender_api_key', $key );

        if (!empty($remote_url) && !empty($token)) {
                $response       = wp_remote_post( $remote_url, array(
                    'body'      => $requestParam,
                    'headers'   => array(
                                    'Authorization' => 'Bearer ' . $token,
                                    ),
                ) );

                if( !is_wp_error( $response) ) {
                    
                    update_option('_kirimwa_temp_ops', json_encode($response));

                    if ( isset($response['body']) ) {
                        $array_res = json_decode( $response['body'], true );

                        if (json_last_error() == JSON_ERROR_NONE) {
                            if( $array_res['code'] == 200) {
                                file_put_contents( MTF_PLUGIN_DIR . 'api.txt', $response['body']);
                                echo $response['body'];
                            }
                        }
                    } else {
                        $write .= '| error: response body error';
                    }
                } else {
                    $write .= '| error: query error';
                }
        } else {
            $write .= '| error: token empty';
        }

        file_put_contents( MTF_PLUGIN_DIR . 'post.txt', $write);

    }

    exit();
}


add_action('init', function(){
    add_filter(ot_settings_id() . '_args', function($custom_settings){
        foreach($custom_settings['settings'] as $key => $item) {
            if ($item['id'] == 'bot_service') {
                // dd($item);
                $adapter = get_option('mtf_adapter', 'wpajax');

                $adapter_url = get_option('kirimwa_url_adapter', admin_url() .'admin-ajax.php?action=kirimwa_adapter' );

                if ($adapter == 'standalone') {
                    $url = plugin_dir_url( __FILE__ ) . 'adapter.php?mode=text';
                    $api_url = get_option('mtf_api_url', '');
                    $api_key = ot_get_option( 'token_key' );

                    $adapter_url = plugin_dir_url( __FILE__ ) . 'adapter.php?mode=text&_key='.$api_key.'&_url='.$api_url;
                }

                // $url = str_replace('https://', 'http://', $url);
                $item['choices'][] = [
                    "value" => $adapter_url,
                    "label" => "KirimWa",
                    "src"   => "",
                ];

                $custom_settings['settings'][$key] = $item;
            }

        }
        return $custom_settings;
    });
});

