console.log('dashboard.js');

const { createApp } = Vue;

const app = createApp({
    data() {
        return {
            version: 1,
            loading: true,
            save_loading: false,
            patch_loading: false,
            test_loading: false,
            active_tab: 1,

            api_url: '',
            api_key: '',
            enable: false,
            onesender_status: 'offline',
            system_info: {
                email: '',
                instance_id: '',
                mysql: '',
                name: '',
                phone: '',
                php_version: '',
                status: '',
                web_server: '',
                wp_version: '',
            },
            field_errors: {
                api_url: '',
                api_key: '',
                enable: '',
                onesender_status: '',
            }
        }
    },

    methods: {
        getApiUrl(path) {
            let prefix = window._OSELF.prefix;
            path = '?action=' + prefix + path;
            return window._OSELF.ajaxurl + path;
        },
        selectTab(i) {
            this.active_tab = i;
        },
        loadData() {
            console.log('Load data');
            this.loading = true;
            let ajaxurl = this.getApiUrl('get_setting');

            fetch(ajaxurl).then((response) => {
                return response.json();
            }).then(function (res) {
                console.log(res.data);

                this.loading = false;
                if (res.success) {
                    let keys = Object.keys(res.data.setting);
                    for(let i = 0; i < keys.length; i++) {
                        let key = keys[i];
                        this[key] = res.data.setting[keys[i]];
                    }
                    this.system_info = res.data.system;
                    
                } else {
                    let errors = Object.keys(res.error);
                     for(let i = 0; i < keys.length; i++) {
                        this.field_errors[keys[i]] = res.error[keys[i].join('. ')];
                    }
                }
            }.bind(this));
        },
        ajaxPost(ajaxurl, data, callable) {
            fetch(ajaxurl, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify(data)
            }).then((response) => {
                return response.json();
            }).then(callable);
        },

        clearSettingErrors() {
            this.field_errors = {
                onesender_api_url: '',
                onesender_api_key: '',
                onesender_enable: '',
                onesender_status: '',
                patch_status: '',
            };
        },

        actionSaveSetting() {
            console.log("Save setting");
            this.clearSettingErrors();

            this.saveLoading = true;

            let ajaxurl = this.getApiUrl('update_setting');

            let keys = ['api_url', 'api_key', 'enable'];
            let payload = {};
            for(let i=0; i < keys.length; i++) {
                payload[keys[i]] = this[keys[i]];
            }

            console.log(payload);

            this.ajaxPost(ajaxurl, payload, function (res) {
                this.saveLoading = false;
                this.loading = false;
                console.log(res);
                if (res.success) {
                    Toaster.alert('Setting updated');
                } else {
                    var err = res.errors;
                    var errorKeys = Object.keys(res.errors);
                    var errorString = '';
                    errorKeys.forEach(function(key){
                        errorString += res.errors[key].join('. ');
                        this.field_errors[key] = res.errors[key].join('. ');
                    }.bind(this));
                    Toaster.alert(errorString, {icon: 'warning'});
                }
            }.bind(this));
        },

        actionTestSender() {
            console.log("Test");
            this.testLoading = true;
            let ajaxurl = this.getApiUrl('test_sender');
            this.ajaxPost(ajaxurl, { nonce: window._OSELF.nonce }, function (res) {
                this.testLoading = false;
                console.log(res);
                if (res.success) {
                    Toaster.alert("Test WhatsApp sender berhasil", {icon: 'info'});
                } else {
                    Toaster.alert("Test WhatsApp sender gagal", {icon: 'warning'});
                }
            }.bind(this));
        },
    },

    computed: {
        senderStatus(){
            let output = '<span class="plwp-pill warning">Error</span>';

            if (this.onesender_status == 'online') {
                output = '<span class="plwp-pill success">Online</span>';
            } else if(this.onesender_status == 'offline') {
                output = '<span class="plwp-pill danger">Offline</span>';
            }

            return output;
        },
        patchStatus() {
            let output = '<span class="plwp-pill danger">Original</span>';

            if (this.patch_status == 'patched') {
                output = '<span class="plwp-pill success">Patched</span>';
            } 

            return output;
        },
        btnPatchLabel(){
            return this.testLoading ? '<i class="dashicons dashicons-update rotate"></i> Loading' : 'Patch sender';
        },
        btnTestLabel() {
            return this.testLoading ? '<i class="dashicons dashicons-update rotate"></i> Loading' : 'Test kirim pesan';
        },
        btnSaveLabel() {
            return this.saveLoading ? '<i class="dashicons dashicons-update rotate"></i> Loading' : 'Simpan pengaturan';
        }
    },

    created() {
        this.loadData();
    }
});

app.mount('#plwpapp');