var Toaster = {
    rootEl: null,
    setFoundation(){
        if (document.body.innerHTML.indexOf('toaster-wrap') > -1) {
            return;
        }
        this.rootEl = document.createElement('div');
        this.rootEl.id = 'toaster';
        this.rootEl.className = 'toaster';
        document.body.appendChild(this.rootEl);
    },
    alert(content, config) {
        this.setFoundation();
        config = this.normalizeConfig(config);
        let iconImg = this.getIcon(config.icon);
        let id = this.randId(5);
        let allcontent = `<div class="toaster-wrap"><a data-id="${id}" href="#" class="toaster-killer" onclick="Toaster.close(event,'${id}')">${this.getCloseIcon()}</a><div class="body ${config.icon}"><div class="icon ${config.icon}">${iconImg}<div class="tinner"></div></div><div class="text">${content}</div></div></div>`;
        elem = document.createElement('div');
        elem.id = id;
        elem.className = 'toaster-item ' + config.icon + ' toaster-item-' + id;
        elem.innerHTML = allcontent;
        this.rootEl.appendChild(elem);

        var counter = 3;
        var popup = setInterval(function(){
            console.log(elem);
            counter--;
            if (counter == 0) {
                elem.remove();
                clearInterval(popup);
            }
        }, 1000);

    },
    randId(length) {
        var result           = 'tst-';
        var characters       = 'abcdefghijklmnopqrstuvwxyz0123456789';
        var charactersLength = characters.length;
        for ( var i = 0; i < length; i++ ) {
            result += characters.charAt(Math.floor(Math.random() * charactersLength));
        }
        return result;
    },
    getIcon(icon) {
        let output = '<svg xmlns="http://www.w3.org/2000/svg" width="512" height="512" viewBox="0 0 512 512"><title>ionicons-v5-e</title><path d="M256,56C145.72,56,56,145.72,56,256s89.72,200,200,200,200-89.72,200-200S366.28,56,256,56Zm0,82a26,26,0,1,1-26,26A26,26,0,0,1,256,138Zm48,226H216a16,16,0,0,1,0-32h28V244H228a16,16,0,0,1,0-32h32a16,16,0,0,1,16,16V332h28a16,16,0,0,1,0,32Z"/></svg>';

        if (icon == 'warning') {
            output = '<svg xmlns="http://www.w3.org/2000/svg" width="512" height="512" viewBox="0 0 512 512"><title>ionicons-v5-a</title><path d="M256,48C141.31,48,48,141.31,48,256s93.31,208,208,208,208-93.31,208-208S370.69,48,256,48Zm0,319.91a20,20,0,1,1,20-20A20,20,0,0,1,256,367.91Zm21.72-201.15-5.74,122a16,16,0,0,1-32,0l-5.74-121.94v-.05a21.74,21.74,0,1,1,43.44,0Z"/></svg>';
        }
        return output;
    },
    getCloseIcon() {
        return '<svg xmlns="http://www.w3.org/2000/svg" width="512" height="512" viewBox="0 0 512 512"><title>ionicons-v5-m</title><path d="M256,48C141.31,48,48,141.31,48,256s93.31,208,208,208,208-93.31,208-208S370.69,48,256,48Zm75.31,260.69a16,16,0,1,1-22.62,22.62L256,278.63l-52.69,52.68a16,16,0,0,1-22.62-22.62L233.37,256l-52.68-52.69a16,16,0,0,1,22.62-22.62L256,233.37l52.69-52.68a16,16,0,0,1,22.62,22.62L278.63,256Z"/></svg>';
    },
    normalizeConfig(config) {
        if (config == undefined) {
            config = {
                position: 'top-right',
                icon: 'info',
                timer: 2000,
                speed: 300,
            };
        }

        return config;
    },
    close(event, id) {
        console.log(event);
        console.log(id);
        document.getElementById(id).remove();
    }
}
