<?php
defined('ABSPATH') or die('No direct access allowed to this file');

require_once OSELF_PATH . 'third-party/autoload.php';

spl_autoload_register( function ( $class ) {
    $prefix 	    = 'OneSender\\Elementor_Form\\';
    $base_dir 	    = OSELF_PATH . 'inc/class/';
    $len 		    = strlen( $prefix );

    if ( strncmp( $prefix, $class, $len ) !== 0 ) {
        return;
    }

    $relative_class = strtolower( substr($class, $len) );
    $relative_class = str_replace( '_', '-', $relative_class );
    $file 			= $base_dir . str_replace( '\\', '/', $relative_class ) . '.php';
    $file_parts 	= pathinfo( $file );
    $file 			= sprintf( '%s/class-%s', $file_parts['dirname'], $file_parts['basename'] );

    if ( file_exists( $file ) ) {
        require_once( $file );
    }

} );

require_once OSELF_PATH . 'inc/helpers/plugin.php';
require_once OSELF_PATH . 'inc/helpers/setting.php';
require_once OSELF_PATH . 'inc/helpers/utils.php';

if ( ! function_exists( 'start_oself_plugin' ) ) {
	function start_oself_plugin() {
		return \OneSender\Elementor_Form\Plugin::instance();
	}
}

add_action( 'plugins_loaded', 'start_oself_plugin' );
