<?php

namespace OneSender\Elementor_Form;

defined('ABSPATH') or die('No direct access allowed to this file');

use OneSender\Elementor_Form\Encryption;
use OneSender\Elementor_Form\Setting;
use OneSender\Elementor_Form\Repository;

class Activation {

    public static function do_activate() {
        self::install_settings();
    }

    public static function get_repo_public_key() {
        return '-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwTnXj4dSv+1qrwwzi+PD
pT2cM/21zGoKc1BIHXtR626M1ufGVWizrp8+FV6xLcETUHNJrbcVyd/6/MrA1T+U
AY+rN+5ysA9KM+mmHKTBMhN4Fr9Ekiud6nrOXxPkXO84Lf02r/cPF5KSTMByInZH
A4JOVjv7oQELspPdTeesLLCIXhz1R8h800kwNPAHBjIO1HKNZ/PPpAk9uLdUY7oT
P+F/ZJBJlVwWg4hV3GIkvd6DJAcZ+zg+S26vJ9RZLmWHb/H0VTkM/JCviViVbRmI
hy9pZ2s1SPnzmd81YhKXHP4rIkPU2L3ll6a8RSLKYrnTLq+KpgJ0S0F5p9LSPdYx
wwIDAQAB
-----END PUBLIC KEY-----';
    }

    public static function install_settings() {
        
        $new_settings =  Encryption::generate_key_pair();
        $new_settings = array_merge( $new_settings, ['repo_public_key' => self::get_repo_public_key() ] );
        $new_settings = array_merge( $new_settings, ['box_key' => Encryption::generate_box_key() ] );
        
        Setting::instance()->install( $new_settings );

        $instance_id = get_option( '_oself_instance_id', false );
        if ( !$instance_id ) {
            update_option( '_oself_instance_id', oself_uuidv4(), true );
        }

        $box_key = get_option( '_oself_box_key', false );
        if ( !$box_key ) {
            update_option( '_oself_box_key', Repository::generate_box_key(), true );
        }

    }
}
