<?php

namespace OneSender\Elementor_Form;

use OneSender\Elementor_Form\Setting;

defined('ABSPATH') or die('No direct access allowed to this file');

class Encryption {

    public static function generate_key_pair() {
        $config 				= array(
            'digest_alg' 		=> 'sha1',
            'private_key_bits' 	=> 2048,
            'encrypt_key' 		=> true
        );

        $key_pair 				= openssl_pkey_new();
        openssl_pkey_export($key_pair, $private_key);

        $public_key 			= openssl_pkey_get_details($key_pair);
        $public_key 			= $public_key['key'];

        return array(
            'private_key' 		=> $private_key,
            'public_key' 		=> $public_key
        );
    }

    public static function rsa_encrypt( string $plain, string $public_key ) {
        openssl_public_encrypt( $plain, $crypted, $public_key );
        return base64_encode($crypted);
    }

    public static function rsa_decrypt( string $chiper_text, string $private_key ) {
        $chiper_text = base64_decode( $chiper_text );
        openssl_private_decrypt( $chiper_text, $decrypted, $private_key );
        return $decrypted;
    }


    public static function generate_box_key() {
        return base64_encode( openssl_random_pseudo_bytes( 32 ) );
    }

    public static function box_encrypt( $plaintext = '', $key = '' ) {
        if (empty($key)) {
            $key = base64_decode( Setting::instance()->get('box_key', '') );
        } else {
            $key = base64_decode( $key );
        }

        $iv = openssl_random_pseudo_bytes( 16 );
        $encrypted = openssl_encrypt( $plaintext, 'AES-256-CBC', $key, OPENSSL_RAW_DATA, $iv );

        if (!$encrypted) {
            return false;
        }

        $encrypted = base64_encode($encrypted) . ':' . base64_encode($iv);
        return base64_encode($encrypted);
    }

    public static function box_decrypt( $encrypted = '', $key = null ) {
        if (empty($key)) {
            $key = base64_decode( Setting::instance()->get('box_key', '') );
        } else {
            $key = base64_decode( $key );
        }

        $parts = explode(':', base64_decode($encrypted));
     
        if (count($parts) !== 2) {
            return false;
        }
     
        $decrypted = openssl_decrypt(
            base64_decode($parts[0]), 
            'AES-256-CBC', 
            $key, 
            OPENSSL_RAW_DATA, 
            base64_decode($parts[1])
        );

        return $decrypted;
    }
}
