<?php

namespace OneSender\Elementor_Form;

defined('ABSPATH') or die('No direct access allowed to this file');

class Plugin {

    public static $instance;

    public static function instance() {
        if (empty(self::$instance)) {
            self::$instance = new Plugin();
        }

        return self::$instance;
    }

    public function __construct() {
        $this->load_modules();
    }

    private function load_modules() {
        $modules = array(
            'Modules\Elementor\Integration',
            'Modules\Admin\Admin_Menu',
            'Modules\Ajax\Ajax_Calls',
            'Repository'
        );

        foreach ( $modules as $module ) {
            $module = 'OneSender\Elementor_Form\\' . $module;
            $module::init();
        }
    }

}
