<?php

namespace OneSender\Elementor_Form;

defined('ABSPATH') or die('No direct access allowed to this file');

use Ds\Map as DsMap;

class Remap {
    
    protected $resource = [];

    public static function make($input) {
        $class = new static($input);
        return $class;
    }

    public function __construct($input) {
        if($input instanceof DsMap) {
            $this->resource = $input;
        } elseif($input instanceof Remap) {
            $this->resource = $input->resource;
        } elseif(is_array($input)) {
            $this->resource = new DsMap($input);
        } else {
            $this->resource = new DsMap([]);
        }
    }

    public function mapWithKeys(callable $callback) {
        $result = [];

        foreach ($this->resource as $key => $value) {
            $assoc = $callback($key, $value);

            foreach ($assoc as $mapKey => $mapValue) {
                $result[$mapKey] = $mapValue;
            }
        }

        return self::make($result);
    }

    public function groupBy($column) {
        $results = [];

        foreach($this->resource as $key => $item) {
            $key = $item[$column];
            $result[$key][] = $item;  
        }
        return self::make($result);
    }

    public function reject(callable $callback) {
        $result = [];

        foreach ($this->resource as $key => $value) {
            $assoc = $callback($key, $value);

            if (!$assoc) {
                $result[$key] = $value;
            }
        }
        return self::make($result);
    }

    public function unique($key = null, $strict = false) {
        if (is_null($key) && $strict === false) {
            return self::make(array_unique($this->resource->toArray(), SORT_REGULAR));
        }

        $callback = $this->resource;

        $exists = [];

        return $this->reject(function ($key, $item) use ($callback, $strict, &$exists) {
            if (in_array($id = $callback($item, $key), $exists, $strict)) {
                return true;
            }

            $exists[] = $id;
        });
    }

    public function implode($join = ',') {
        return implode($join, $this->resource->toArray());
    }

    public function join($join = ',') {
        return implode($join, $this->resource->toArray());
    }

    public function count() {
        return $this->resource->count();
    }
    
    public function put($key = '', $value = null) {
        return $this->resource->put($key, $value);
    }

    public function get($key = null, $default = null) {
        return $this->resource->get($key, $default);
    }

    public function toArray() {
        return $this->resource->toArray();
    }

    public function toObject() {
        return (object) $this->resource->toArray();
    }
    
    public function __call($method, $params) {
        $this->resource = $this->resource->{$method}(...$params);
        return $this;
    }
}
