<?php

namespace OneSender\Elementor_Form;

defined('ABSPATH') or die('No direct access allowed to this file');

class Setting {

    const SETTING_KEY = '_oself_settings';

    public static $instance;

    public static function instance() {
        if (empty(self::$instance)) {
            self::$instance = new Setting();
        }

        return self::$instance;
    }

    public $settings = [];

    public function __construct() {

        $this->settings = self::get_options();
    }

    public static function get_options() {
        $default        = self::default_value();
        $settings       = get_option( self::SETTING_KEY, $default );
        if (is_string($settings)) {
            $settings   = maybe_unserialize( $settings );
        }
        $settings       = wp_parse_args( $settings, $default );

        return self::sanitize_options( $settings );
    }

    public static function default_value() {
        return array(
            'uninstall_remove_setting'  => false, 
            'uninstall_remove_data'     => false, 
            'onesender_api_url'         => '', 
            'onesender_api_key'         => '', 
            'enable_service'            => false, 
        );
    }

    public static function sanitize_options( $input ) {
        $base = self::default_value();

        foreach($base as $key => $value) {
            $user_value = $input[$key] ?? $value;

            if (is_array($user_value)) {
                $user_value = json_encode($user_value);
            }
            $base[$key] = trim($user_value);
        }

        $booleans = array( 'enable_service', 'uninstall_remove_setting', 'uninstall_remove_data' );
        foreach( $booleans as $sub ) {
            $base[$sub]     = boolval($base[$sub]);
        }

        if (!empty($base['onesender_api_url'])) {
            if ( filter_var($base['onesender_api_url'], FILTER_VALIDATE_URL) === false ) {
                $base['onesender_api_url'] = '';
            }
        }

        return $base;
    }

    public static function install( $data = array()) {
        $default_settings = self::default_value();
        $settings = self::sanitize_options( $default_settings );
        $settings = array_merge( $settings, $data );

        foreach($settings as $key => $val) {
            if (!in_array($key, array_keys($default_settings))) {
                unset( $settings[$key] );
            }
        }

        update_option( self::SETTING_KEY, maybe_serialize( $settings ), true );

        return true;
    }

    public function get($key = '', $default = null) {
        return $this->settings[$key] ?? $default;
    }

    public function set($key = '', $value = null) {
        return $this->settings[$key] = $value;
    }

    public function save() {

        if ( empty($this->settings) ) {
            return false;
        }

        update_option( self::SETTING_KEY, maybe_serialize( $this->settings ), true );
        return true;
    }
}
