<?php

namespace OneSender\Elementor_Form;

defined('ABSPATH') or die('No direct access allowed to this file');

use \Mustache_Engine;

class Utils {

    public static function parse_message_template( $text, $data ) {
        $m = new Mustache_Engine( array('entity_flags' => ENT_QUOTES) );
        return $m->render( $text, $data);
    }
    
    public static function send_texts( $texts ) {
        $remote_url     = self::get_api_url();
        $token          = oself_get_option('onesender_api_key', home_url() );

        $headers = array( 
            'Authorization' => 'Bearer ' . $token, 
            'Content-Type' => 'application/json'
        );

        $messages = array();

        foreach($texts as $text) {
            $content = self::reformat_text( $text['message'] );

            $messages[]     = [
                'to'             => $text['to'],
                'recipient_type' => 'individual',
                'type'           => 'text',
                'text'           => ['body' => $content],
            ];
        }

        $args = array(
            'body'          => json_encode( $messages ),
            'sslverify'     => false,
            'headers'       => $headers,
            'method'        => 'POST',
            'data_format'   => 'body'
        );

        $response = wp_remote_post( $remote_url, $args );
                 
        if ( is_wp_error( $response ) ) {
            $error_message = $response->get_error_message();
            return "Something went wrong: $error_message";
        } 

        return wp_remote_retrieve_body( $response );
    }
    public static function send_messages( $messages = array()) {
        if ( empty($messages) ) return false;

        $remote_url     = self::get_api_url();
        $token          = oself_get_option('onesender_api_key', home_url() );

        $headers = array( 
            'Authorization: Bearer ' . $token, 
            'Content-Type: application/json'
        );

        $curl = curl_init();

        curl_setopt_array( 
            $curl, 
            array(
                CURLOPT_URL => $remote_url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => json_encode( $messages ),
                CURLOPT_HTTPHEADER => $headers,
            ) 
        );

        $response = curl_exec($curl);

        curl_close($curl);
        return $response;
    }

    public static function send_text( $jid, $text ) {
        $remote_url     = self::get_api_url();
        $token          = oself_get_option('onesender_api_key', home_url() );

        $headers = array( 
            'Authorization' => 'Bearer ' . $token, 
            'Content-Type' => 'application/json'
        );

        $text = self::reformat_text( $text );
        $messages[]     = [
            'to'             => $jid,
            'recipient_type' => 'individual',
            'type'           => 'text',
            'text'           => ['body' => $text],
        ];

        $args = array(
            'body'          => json_encode( $messages ),
            'sslverify'     => false,
            'headers'       => $headers,
            'method'        => 'POST',
            'data_format'   => 'body'
        );
         
        $response = wp_remote_post( $remote_url, $args );
                 
        if ( is_wp_error( $response ) ) {
            $error_message = $response->get_error_message();
            return "Something went wrong: $error_message";
        } 

        return wp_remote_retrieve_body( $response );
    }


    public static function get_api_url() {
        $api_server = oself_get_option('onesender_api_url', home_url() );
        return self::auto_format_os_api_url( $api_server );
    }

    public static function auto_format_os_api_url($url) {
        if( filter_var( $url, FILTER_VALIDATE_URL ) === false )
            return;

        $url_parts = parse_url($url);

        $url_parts = wp_parse_args( $url_parts, array(
            'scheme'    => $url_parts['scheme'],
            'host'      => $url_parts['host'],
            'port'      => false,
            'path'      => $url_parts['path']
        ) );
        
        $api_server = sprintf( '%s://%s/api/v1/messages',
            $url_parts['scheme'],
            $url_parts['host']
        );

        if ( !empty( $url_parts['port'] ) ) {
            $api_server = sprintf( '%s://%s:%s/api/v1/messages',
                $url_parts['scheme'],
                $url_parts['host'],
                $url_parts['port']
            );
        }

        $api_server = apply_filters( 'onesender/elementor-form/os_api_url', $api_server );
        return $api_server;
    }

    public static function reformat_text( $text ) {
        $text = html_entity_decode( $text );
        $text = str_replace( 
            array("&amp;", "&lt;", "&gt;"),
            array("&", "<", ">"),
            $text
        );
        return $text;
    }

    public static function is_url( $url ) {
        if ( filter_var($url, FILTER_VALIDATE_URL) === false ) {
            return false;
        }

        return true;
    }
}