<?php

namespace OneSender\Elementor_Form\Modules\Admin;

defined('ABSPATH') or die('No direct access allowed to this file');

use OneSender\Elementor_Form\Repository;

class Admin_Menu {

     public static function init() {
         $class = new static();
    }

    public function __construct() {
        add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ) );

        add_action( 'admin_menu', array( $this, 'add_menu_page' ) );

        if( !Repository::instance()->is_validated() ) {
            add_action( 'admin_head', array( $this, 'activation_header_css' ) );
        } else {
            add_filter( 'plugin_action_links', array($this, 'plugin_menu_links' ), 15, 2 );
        }
    }

    public function add_menu_page() {
        add_menu_page(
            'OneSender ElPro',
            'OneSender ElPro',
            'manage_options',
            'oself',
            array( $this, 'render_dashboard' ),
            OSELF_URL . 'assets/img/onesender-logo-wp.svg',
            3
        );
    }

    public function render_dashboard() {
        if( Repository::instance()->is_validated() ) {
            load_template( OSELF_PATH . 'inc/resources/views/dashboard-setting.php', true, array() );
        } else {
            load_template( OSELF_PATH . 'inc/resources/views/activate.php', true, array() );
        }
    }


    public function admin_scripts( $hook ) {
        if ( $hook !== 'toplevel_page_oself' ) return;

        wp_register_style( 'oself-toaster', oself_asset('assets/css/toaster.css'), false, '1.0.0' );
        wp_register_style( 'oself-dashboard', oself_asset('assets/css/dashboard.css'), false, '1.0.0' );
        wp_enqueue_style( 'oself-toaster' );
        wp_enqueue_style( 'oself-dashboard' );

        wp_register_script( 'oself-toaster', oself_asset( 'assets/js/toaster.js' ), array(), false, true );
        wp_register_script( 'oself-vue', oself_asset( 'assets/js/vue.js' ), array('oself-toaster'), false, true );
        wp_register_script( 'oself-dashboard-setting', oself_asset( 'assets/js/dashboard-setting.js' ), array('oself-vue'), false, true );
        wp_enqueue_script( 'oself-vue' );
        
        if( !Repository::instance()->is_validated() ) {
            wp_register_script( 'oself-activate', oself_asset( 'assets/js/activate.js' ), array('oself-vue'), false, true );
            wp_enqueue_script( 'oself-activate' );
            wp_localize_script( 'oself-activate', '__PLWPACTIVATE', array(
                'nonce'     => wp_create_nonce(),
                'ajaxurl'   => admin_url( 'admin-ajax.php' ),
                'prefix'    => 'oself_',
            ) );
            return;
        }
        
        wp_enqueue_script( 'oself-toaster' );
        wp_enqueue_script( 'oself-dashboard-setting' );
        wp_localize_script( 'oself-dashboard-setting', '_OSELF', array(
            'nonce'     => wp_create_nonce( 'oself' ),
            'ajaxurl'   => admin_url( 'admin-ajax.php' ),
            'prefix'    => 'oself_',
        ) );
    }

    public function plugin_menu_links( $options_links, $starter_file ) {
        if ( 'onesender-elementor-form/onesender-elementor-form.php' == $starter_file ) {
            $base_links['menu_link'] = sprintf('<a href="%s">Setting</a>', admin_url( 'admin.php?page=oself' ) );
            $options_links = array_merge($base_links, $options_links);
            $update_link = sprintf('<a href="%s" style="color: #d63638;">Update</a>', admin_url( 'plugins.php?force_update=true' ) );
            $options_links['force_update'] = $update_link;
        }

        return $options_links;
    }

    public function activation_header_css() {
        echo '<style type="text/css">.plwpa *{box-sizing:border-box;font-size:15px;line-height:1.5}.plwpa{background:rgb(255,255,255);border:1px solid rgba(100,100,100,.2);border-radius:4px;max-width:480px;margin:5vh auto;overflow:hidden}.plwpa #email{padding-left:32px}.plwpa .bg-email{position:relative}.plwpa .bg-email:after{content:"\f466";color:#8c8f94;font-family:dashicons;line-height:1;font-weight:400;font-style:normal;text-transform:none;text-rendering:auto;font-size:18px;text-align:center;position:absolute;left:8px;top:12px;height:17px;width:20px}.plwpa .error-msg{border:1px solid #fba4a5;color:#d63638;background:#fff7f7;padding:8px 16px;border-radius:3px}.plwpa .fold{transition:height .3s ease-in-out}.plwpa.loading>.inner .preloader{display:flex;text-align:center;line-height:200px;background-color:#fff9;top:0;position:absolute;height:100%;width:100%;z-index:15}.plwpa .inner{position:relative}.plwpa .inner .slide-process{transition:all .3s ease-in-out;width:100%}.plwpa .inner .slide-success{position:absolute;height:100%;width:100%;left:100%;top:0;transition:all .3s ease-in-out;text-align:center}.plwpa .inner.act-success .slide-process{margin-left:-100%}.plwpa .inner.act-success .slide-success{display:flex;flex-direction:column;flex-wrap:wrap;justify-content:center;align-items:center;align-content:stretch;left:0}.plwpa .guide{border-top:1px dotted rgba(100,100,100,.2);padding:24px 0;margin:0 24px}.plwpa .guide ul{margin:0;padding-left:20px}.plwpa .guide li{position:relative}.plwpa .guide li:after{content:"\f12a";color:#13962e;font-family:dashicons;line-height:1;font-weight:400;font-style:normal;text-transform:none;text-rendering:auto;font-size:14px;text-align:center;position:absolute;left:-21px;top:5px;height:15px;width:15px}.plwpa .step{padding:24px}.plwpa .step:nth-child(2){padding-top:0;padding-bottom:36px}.plwpa .step .step-inner{padding-top:4px;padding-left:46px;position:relative}.plwpa .step-title{font-weight:600}.plwpa .step-number{position:absolute;left:0;top:5px;border:1px solid rgba(100,100,100,.2);border-radius:14px;line-height:25px;text-align:center;height:28px;width:28px;z-index:10;background-color:#fff}.plwpa .step.active .step-number{background-color:#135e96;color:#fff}.plwpa .form-group label{display:none}.plwpa .form-group input{width:100%}.plwpa .step-1{position:relative}.plwpa .step-1:before{content:"";position:absolute;top:60px;left:38px;width:10px;height:90%;z-index:1;border-left:1px solid rgba(100,100,100,.2)}.plwpa .step-1 .form-wrap,.plwpa .step-1 .step-text{display:none;margin-bottom:10px}.plwpa .step-1 .step-action{display:block}.plwpa .step-1.active .form-wrap{display:flex}.plwpa .step-1.active .step-text{display:block}.plwpa .step-1.active .step-action{display:none}.plwpa .step-1 .form-group:nth-child(1){flex:1;margin-right:12px}.plwpa .step-2{position:relative;overflow:hidden}.plwpa .step-2:before{content:"";position:absolute;top:2px;left:33px;width:10px;height:100%;z-index:1;background-color:#fff}.plwpa .step-2 .step-text{margin-bottom:10px}.plwpa .step-2 .body{overflow:hidden}.plwpa .step-2 .form-wrap{display:block;position:relative;max-width:250px;overflow:hidden;height:42px;margin:14px 0}.plwpa .step-2 .form-wrap input{background-color:transparent;border:1px solid rgba(100,100,100,.2);border-radius:4px;text-align:center;line-height:36px;font-size:22px;padding:0}.plwpa .step-2 .form-wrap input:focus{outline:none}.plwpa .step-2 .form-wrap .form-group{position:absolute;height:100%;width:100%;z-index:2}.plwpa .step-2 .body.fold{height:0px}.plwpa .step-2 .box-wrap{z-index:1;position:absolute;top:0;left:0;width:100%;height:100%;display:flex;flex-wrap:wrap}.plwpa .step-2 .box-wrap div{height:36px;width:30px;margin:0 6px;padding:2px 0;display:inline-block;cursor:pointer}.plwpa .step-2 .box-wrap div:nth-child(1){margin-left:0}.plwpa .step-2 .box-wrap div:nth-child(6){margin-right:0}.plwpa .step-2 .box-wrap div.active{border-color:#000}.plwpa #otp{font-size:22px;letter-spacing:29px;padding:0 0 0 8px;font-family:JetBrains Mono,monospace}.attribution{text-align:center}.attribution *{font-size:10px;text-decoration:none;color:#64646499}.preloader{display:none;flex-direction:row;flex-wrap:nowrap;justify-content:center;align-items:center;align-content:stretch}.lds-dual-ring{display:inline-block;width:80px;height:80px}.lds-dual-ring:after{content:" ";display:block;width:56px;height:56px;margin:8px;border-radius:50%;border:6px solid #135e96;border-color:#135e96 transparent #135e96 transparent;animation:lds-dual-ring 1.2s linear infinite}@keyframes lds-dual-ring{0%{transform:rotate(0)}to{transform:rotate(360deg)}} </script>';
    }
}