<?php

namespace OneSender\Elementor_Form\Modules\Ajax;

defined('ABSPATH') or die('No direct access allowed to this file');

use OneSender\Elementor_Form\Repository;

class Ajax_Calls {
	public static function init() {
         $class = new static();
    }

    public function __construct() {
        add_action( 'wp_ajax_oself_get_setting', array($this, 'get_settings') );
        add_action( 'wp_ajax_oself_update_setting', array($this, 'update_settings') );
        add_action( 'wp_ajax_oself_test_sender', array($this, 'do_test_sender') );

        add_action( 'wp_ajax_nopriv_oself_update_setting', array($this, 'unauthorized') );
        add_action( 'wp_ajax_nopriv_oself_update_setting', array($this, 'unauthorized') );
    }

    public function get_settings() {
        global $current_user;

        if (!isset($current_user->allcaps['administrator'])) {
            return wp_send_json([
                'success' => false,
                'message' => 'Unauthorized access',
            ]);
        }


        $class = new Get_Settings();
        return $class->response();
    }

    public function update_settings() {
        global $current_user;

        if (!isset($current_user->allcaps['administrator'])) {
            return wp_send_json([
                'success' => false,
                'message' => 'Unauthorized access',
            ]);
        }


        $class = new Update_Settings();
        return $class->response();
    }

    public function do_test_sender() {
        global $current_user;

        if (!isset($current_user->allcaps['administrator'])) {
            return wp_send_json([
                'success' => false,
                'message' => 'Unauthorized access',
            ]);
        }

        $class = new Test_Sender();
        return $class->response();
    }

    public function unauthorized() {
        return wp_send_json([
            'success' => false,
            'message' => 'Unauthorized. Anda tidak memiliki akses untuk membuka halmaan ini.',
            'errors' => [],
        ]);
    }
}
