<?php

namespace OneSender\Elementor_Form\Modules\Ajax;

defined('ABSPATH') or die('No direct access allowed to this file');

use OneSender\Elementor_Form\Repository;

class Get_Settings {

	public function response() {
		global $current_user;

		if ( !isset( $current_user->allcaps['administrator'] ) ) {
            return wp_send_json([
                'success' => false,
                'message' => 'Unauthorized access',
            ]);
        }
        
		$url = strval( oself_get_option('onesender_api_url') );
		$key = strval( oself_get_option('onesender_api_key') );
		$enable = boolval( oself_get_option('enable_service') );

        $output = [
            'success' => true,
            'message' => 'Get settings',
            'data' => [
                'setting' => [
                    'api_url' => $url,
                    'api_key' => $key,
                    'enable' => $enable,
                ],
                'system' => $this->get_systems(),
            ],
        ];


        return wp_send_json( $output );
	}

    private function get_systems() {
        global $wp_version;
        $output = Repository::instance()->get_owner();
        return array_merge( $output, array(
            'wp_version' => $wp_version,
            'php_version' => phpversion(),
            'web_server' => $_SERVER['SERVER_SOFTWARE'] ?? '',
            'mysql' => mysqli_get_client_info(),
        ) );
    }
}
