<?php

namespace OneSender\Elementor_Form\Modules\Ajax;

defined('ABSPATH') or die('No direct access allowed to this file');

use OneSender\Elementor_Form\Utils;

class Test_Sender {

    public function response() {

        global $current_user;

        if ( !isset( $current_user->allcaps['administrator'] ) ) {
            return wp_send_json([
                'success' => false,
                'message' => 'Unauthorized access',
            ]);
        }

        $phone = apply_filters( 'onesender/elementor-forms/test_phone', '6281227494445' ); 
        $message = sprintf("Test kirim pesan Berhasil.\n\n✅ Website: *%s* \n✅ Plugin: *Elementor Form*\n✅ Date: *%s*",
                home_url(),
                wp_date( 'Y-m-d H:i')
            );

        $send = Utils::send_text( $phone, apply_filters( 'onesender/elementor-forms/test_message', $message ) );
        $output = [
            'success' => true,
            'message' => 'Test sender',
            'data' => [
               'test' => $send,
            ],
        ];

        return wp_send_json( $output );
    }


    public function validate( $input ) {
        $v = new Validator( $input );

        $v->rule( 'required', [
            'api_key',
            'api_url',
        ] );

        $v->rule( 'url', 'api_url' );

        return array( $v->validate(), $v->errors(), $input );
    }
}
