<?php

namespace OneSender\Elementor_Form\Modules\Ajax;

defined('ABSPATH') or die('No direct access allowed to this file');

use Valitron\Validator;

class Update_Settings {

    public function response() {
        global $current_user;

        if ( !isset( $current_user->allcaps['administrator'] ) ) {
            return wp_send_json([
                'success' => false,
                'message' => 'Unauthorized access',
            ]);
        }

        $input = oself_get_input_json();

        list( $success, $errors, $input ) = $this->validate( $input );
        if ( !$success ) {
            $error_message = oself_collect($errors)->map(function($key, $item) {
                if (is_array($item)) {
                    return implode('. ', $item);
                }

                return $item;
            })->toArray();


            return wp_send_json([
                'success' => false,
                'message' => trim(implode('. ', $error_message)),
                'errors' => $errors,
            ]);

        }

        $enable = $input['enable'] === true ? 1 : 0;
        oself_set_option( 'onesender_api_url', $input['api_url'] );
        oself_set_option( 'onesender_api_key', $input['api_key'] );
        oself_set_option( 'enable_service', $enable );
        oself_save_option();

        $output = [
            'success' => true,
            'message' => 'Settings updated',
            'data' => [
                'setting' => [
                    'api_url' => $input['api_url'],
                    'api_key' => $input['api_key'],
                    'enable' => $input['enable'],
                ],
            ],
        ];

        return wp_send_json( $output );
    }


    public function validate( $input ) {
        $v = new Validator( $input );

        $v->rule( 'required', [
            'api_key',
            'api_url',
        ] );

        $v->rule( 'url', 'api_url' );

        return array( $v->validate(), $v->errors(), $input );
    }
}
