<?php

namespace OneSender\Elementor_Form\Modules\Elementor;

defined('ABSPATH') or die('No direct access allowed to this file');

class Message_Builder {

	public static function make( $type = 'text', $args = []) {
        $args = array_merge( [
            'phone' => '',
            'content' => '',
            'media' => '',
        ], $args );

        $valid = self::validate( $args );

        if (!$valid) {
            return false;
        }   

        return self::create_message( $type, $args ); // $output;
    }

    public static function create_message( $type, $args) {
        $output         = array();

        $recipient_type = strpos($args['phone'], '@g.us') ? 'group' : 'individual';
        $base           = [
                'to'             => $args['phone'],
                'recipient_type' => $recipient_type,
            ];

        if ($type == 'image') {
            $output[] = array_merge( $base, [
                'type'  => 'image', 
                'image' =>  [
                    'link' => $args['media'],
                    'caption' => $args['content'] ?? '',
                ]
            ]);
           
        } elseif ($type == 'document') {
            
            if ( !empty($args['content']) ) {
                $output[] = array_merge( $base, [
                    'type' => 'text',
                    'text' =>  [
                        'body' => $args['content'],
                    ]
                ]);
            }

            $output[] = array_merge( $base, [
                    'type'      => 'document', 
                    'document'  =>  [
                        'link'  => $args['media'],
                    ]
                ]);

        } else {
            $output[] = array_merge( $base, [
                'type' => 'text', 
                'text' =>  [
                    'body' => $args['content'],
                ]
            ]);
        }

        return count($output) > 0 ? $output : false;
    }

    public static function validate($args) {
        if ( empty($args['phone']) || empty($args['content']) ) {
            return false;
        }

        if ( in_array( $type, ['image', 'document'] ) ) {
            if (empty($args['media'])) {
                return false;
            } elseif (filter_var($url, FILTER_VALIDATE_URL) === false) {
                return false;
            }
        }

        return true;
    }
}