<?php

namespace OneSender\Elementor_Form\Modules\Elementor;

defined('ABSPATH') or die('No direct access allowed to this file');

use \Elementor\Controls_Manager;
use \ElementorPro\Modules\Forms\Classes\Action_Base;
use OneSender\Elementor_Form\Utils;

class OneSender_Action extends Action_Base {

	public function get_name() {
		return 'onesender';
	}

	public function get_label() {
		return esc_html__( 'OneSender', 'elementor-pro' );
	}

	public function register_settings_section( $widget ) {

		$widget->start_controls_section(
			'section_onesender',
			[
				'label' 		=> __( 'OneSender', 'elementor-pro' ),
				'condition' 	=> [
					'submit_actions' => $this->get_name(),
				],
			]
		);

		$widget->add_control(
			'onesender_enabled',
			[
				'label' 		=> __( 'Aktifkan', 'elementor-pro' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'default' 		=> 'no', // yes,no
			]
		);
		$widget->add_control(
			'onesender_message_type',
			[
				'label' 		=> esc_html__( 'Message type', 'elementor-pro' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'text',
				'options' 		=> [
					'text' 		=> esc_html__( 'Text', 'elementor-pro' ),
					'image' 	=> esc_html__( 'Image', 'elementor-pro' ),
					'document' 	=> esc_html__( 'Document', 'elementor-pro' ),
				],
				'description' 	=> esc_html__( 'Message type: text, image, document', 'elementor-pro' ),
			]
		);
		
		$widget->add_control(
			'onesender_media',
			[
				'label' 		=> esc_html__( 'Media field ID', 'elementor-pro' ),
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> 'Isi kolom ini dengan id field attachment. Untuk pesan gambar dan dokumen',
				'description' 	=> esc_html__( 'Attachment media', 'elementor-pro' ),
			]
		);


		$widget->add_control(
			'onesender_phone',
			[
				'label' 		=> esc_html__( 'ID Kolom whatsapp ', 'elementor-pro' ),
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> '',
				'description' 	=> esc_html__( 'ID kolom WhatsApp penerima', 'elementor-pro' ),
			]
		);

		$widget->add_control(
			'onesender_template',
			[
				'label' 		=> esc_html__( 'Template pesan', 'elementor-pro' ),
				'type'			=> Controls_Manager::TEXTAREA,
				'placeholder' 	=> '',
				'description' 	=> esc_html__( 'Template pengiriman pesan utama. {{shortcode}}', 'elementor-pro' ),
			]
		);

		$widget->add_control(
			'hr',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$widget->add_control(
			'onesender_forward_enabled',
			[
				'label' 		=> __( 'Aktifkan forward', 'elementor-pro' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'default' 		=> 'no', // yes,no
			]
		);

		$widget->add_control(
			'onesender_forward_message_type',
			[
				'label' 		=> esc_html__( 'Message type', 'elementor-pro' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'text',
				'options' 		=> [
					'text' 		=> esc_html__( 'Text', 'elementor-pro' ),
					'image' 	=> esc_html__( 'Image', 'elementor-pro' ),
					'document' 	=> esc_html__( 'Document', 'elementor-pro' ),
				],
				'description' 	=> esc_html__( 'Message type: text, image, document', 'elementor-pro' ),
			]
		);
		
		$widget->add_control(
			'onesender_forward_media',
			[
				'label' 		=> esc_html__( 'Media field ID', 'elementor-pro' ),
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> 'Isi kolom ini dengan id field attachment. Untuk pesan gambar dan dokumen',
				'description' 	=> esc_html__( 'Attachment media', 'elementor-pro' ),
			]
		);

		$widget->add_control(
			'onesender_forward_phone',
			[
				'label' 		=> esc_html__( 'Tujuan ke-2', 'elementor-pro' ),
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> '',
				'description' 	=> esc_html__( 'Nomor penerima lain', 'elementor-pro' ),
			]
		);
		$widget->add_control(
			'onesender_forward_template',
			[
				'label' 		=> esc_html__( 'Template tujuan ke-2', 'elementor-pro' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'placeholder' 	=> '',
				'description' 	=> esc_html__( 'Template pengiriman pesan. {{shortcode}}', 'elementor-pro' ),
			]
		);
        
		$widget->end_controls_section();
	}

	public function on_export( $element ) {
		unset(
			$element['onesender_enabled'],
			$element['onesender_message_type'],
			$element['onesender_media'],
			$element['onesender_template'],
			$element['onesender_forward_enabled'],
			$element['onesender_forward_message_type'],
			$element['onesender_forward_media'],
			$element['onesender_forward_phone'],
			$element['onesender_forward_template'],
		);
	}

	public function run( $record, $ajax_handler ) {

		$sent_data = $record->get( 'sent_data' );
		$settings = $record->get( 'form_settings' );
		$fields = $record->get( 'fields' );

		$messages = array();

		$enabled = $settings['onesender_enabled'];
		if( 'yes' == $enabled ) {
			$type = $settings['onesender_message_type'];
			$content = $settings['onesender_template'] ?? '';
			$content = Utils::parse_message_template( $content, $sent_data );

			$phone_key = trim( $settings['onesender_phone'] );
			$media_key = trim( $settings['onesender_media'] );
			$media = Utils::is_url( $media_key ) ? $media_key : ( $fields[$media_key]['value'] ?? '' );

			$args = [
				'phone' 	=> oself_clear_phone_number( $sent_data[$phone_key] ?? '' ),
				'content' 	=> $content,
				'media' 	=> $media,
			];

			$message = Message_Builder::make($type, $args);
			if ($message) {
				$messages = array_merge( $messages, $message );
			}
		}

		$enabled = $settings['onesender_forward_enabled'];
		if( 'yes' == $enabled ) {
			$type = $settings['onesender_forward_message_type'];

			$content = $settings['onesender_forward_template'] ?? '';
			$content = Utils::parse_message_template( $content, $sent_data );

			$media_key = trim( $settings['onesender_forward_media'] );
			$media = Utils::is_url( $media_key ) ? $media_key : ( $fields[$media_key]['value'] ?? '' );
			$args = [
				'phone' 	=> oself_clear_phone_number( $settings['onesender_forward_phone'] ?? '' ),
				'content' 	=> $content,
				'media' 	=> $media,
			];

			$message = Message_Builder::make($type, $args);
			if ($message) {
				$messages = array_merge( $messages, $message );
			}
		}

		if (count($messages) > 0) {
			$send = Utils::send_messages( $messages );
		}
	}
}