<?php
defined('ABSPATH') or die('No direct access allowed to this file');

function oself_uuidv4() {
    return sprintf(
			'%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
			wp_rand( 0, 0xffff ),
			wp_rand( 0, 0xffff ),
			wp_rand( 0, 0xffff ),
			wp_rand( 0, 0x0fff ) | 0x4000,
			wp_rand( 0, 0x3fff ) | 0x8000,
			wp_rand( 0, 0xffff ),
			wp_rand( 0, 0xffff ),
			wp_rand( 0, 0xffff )
    );
}

function oself_get_input_json() {
	$raw = file_get_contents( 'php://input' );
	$json = json_decode( $raw, true );

	if ( json_last_error() !== JSON_ERROR_NONE ) {
		return array();
	}

	return $json;
}


function oself_get_string_errors($errors) {
	return oself_collect($errors)->map(function($key, $item) {
                if (is_array($item)) {
                    return implode('. ', $item);
                }

                return $item;
            })->toArray();

}