<?php
defined('ABSPATH') or die('No direct access allowed to this file');

use Ds\Vector;
use OneSender\Elementor_Form\Remap;


function oself_asset( $path ) {
	return OSELF_URL . $path;
}


function oself_map( $args ) {
    return new Remap( $args );
}

function oself_collect( $args ) {
    return new Remap( $args );
}

function oself_vector( $args ) {
    return new Vector( $args );
}

function oself_clear_phone_number( $number ) {
    $number = preg_replace( '/[^0-9]/', '', $number );
    if ( strlen( trim( $number ) ) == 0 ) {
        return false;
    } 

    if ( substr( $number, 0, 1 ) == "0" ) {
        return "62" . substr( $number, 1 );
    } else if ( substr( $number, 0, 1 ) == "+" ) {
        return substr( $number, 1 );
    }
    return $number;
}


function oself_clean_message( $message ) {

    if ( empty( $message ) ) return '';

    $message = str_replace(
            array('<br>', '</p>', '</pre>', '</h1>', '</h2>', '</h3>', '</h4>'), 
            array("<br>\n", "</p>\n", "</pre>\n", "</h1>\n", "</h2>\n", "</h3>\n", "</h4>\n"), 
            $message
        );
    $message = strip_tags( $message, '<strong><em><del><pre>' );
    $message = html_entity_decode( $message );
    $html_tags = array( 
            '<strong>',
            '</strong>',
            '<em>',
            '</em>',
            '<del>',
            '</del>',
            '<pre>',
            '</pre>'
        );

    $markdown_tags = array( '*', '*', '_', '_', '~', '~', '```', '```' );
    $message = str_replace( $html_tags, $markdown_tags, $message );
    $message = trim( $message );

    return $message;
}