<?php 

/**
 * @wordpress-plugin
 * Plugin Name:       OneSender Elementor Form
 * Plugin URI:        https://plugin.my.id/onesender-elementor-form/
 * Description:       OneSender elementor form
 * Version:           1.1.1
 * Author:            M Ali
 * Author URI:        https://plugin.my.id
 * License:           ONESENDER
 * License URI:       https://plugin.my.id/onesender-elementor-form/license/
 */


define( 'OSELF_VERSION',        '1.1.1' );
define( 'OSELF_BUILD_VERSION',  1101 );
define( 'OSELF_PATH',           plugin_dir_path( __FILE__ ) );
define( 'OSELF_URL',            plugin_dir_url( __FILE__ ) );
define( 'OSELF_PLUGIN_FILE',    __FILE__ );
define( 'OSELF_VIEW_DIR',       plugin_dir_path( __FILE__ ) . 'inc/resources/views' );

require_once OSELF_PATH . 'inc/bootstrap.php';

function oself_check_system_requirements() {
    global $wp_version;

    $valid          = true;
    $errors         = array();

    if( version_compare( PHP_VERSION, '7.4.0' ) <= 0 ) {
        $valid      = false;
        $errors[]   = 'Versi PHP minimal 7.4';
    }

    if( version_compare( $wp_version, '5.9.0' ) <= 0 ) {
        $valid      = false;
        $errors[]   = 'Versi WordPress minimal 5.9';
    } 

    if ( ! function_exists( 'is_plugin_active' ) ) {
        require_once ABSPATH . 'wp-admin/includes/plugin.php';
    }

    if ( !is_plugin_active( 'elementor-pro/elementor-pro.php' ) ) {
        if ( !is_plugin_active( 'pro-elements/pro-elements.php' ) ) {
            $valid      = false;
            $errors[]   = 'Please install and activate Elementor Pro';
        }
    }

    return array( $valid, $errors );
}

list( $valid, $check_errors ) = oself_check_system_requirements();

if ( !$valid ) {
    add_action('admin_notices', function() use($check_errors) {
        echo '<div class="notice notice-error" style="padding-top: 15px;">';
        echo '<strong>Plugin OneSender Elementor Form error: </strong>';
        echo '<ul>';
        foreach($check_errors as $entry) {
            echo '<li>'. $entry .'</li>';
        }
        echo '</ul>';
        echo '</div>';
    });
} 

register_activation_hook( __FILE__, function() {
    require_once OSELF_PATH . 'inc/class/class-activation.php';
    \OneSender\Elementor_Form\Activation::do_activate();
});

