console.log('dashboard.js');

const { createApp } = Vue;

const app = createApp({
    data() {
        return {
            version: 1,
            loading: true,
            saveLoading: false,
            testLoading: false,
            apiKey: '',
            apiUrl: '',
            adminPhones: '',
            enableProductMessage: false,

            senderPhone: 'n/a',
            senderStatus: 'n/a',
            senderPause: true,
        }
    },

    methods: {
        getApiUrl(path) {
            let prefix = window.__OSSL.prefix;
            path = '?action=' + prefix + path;
            return window.__OSSL.ajaxurl + path;
        },
        loadData() {
            console.log('load app');
            this.loading = true;
            let ajaxurl = this.getApiUrl('get_setting');

            fetch(ajaxurl).then((response) => {
                return response.json();
            }).then(function (res) {
                this.loading = false;
                if (res.success) {
                    var data = res.data.setting;
                    this.apiUrl = data.onesender_api_url;
                    this.apiKey = data.onesender_api_key;
                    this.adminPhones = data.admin_phones;

                    var sender = res.data.sender;
                    this.senderPhone = sender.sender_number;
                    this.senderStatus = sender.status;
                    this.senderPause = sender.pause;
                }

            }.bind(this));
        },
        ajaxPost(ajaxurl, data, callable) {
            fetch(ajaxurl, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify(data)
            }).then((response) => {
                return response.json();
            }).then(callable);
        },

        btnSaveSetting() {
            console.log("Save setting");
            this.saveLoading = true;

            let ajaxurl = this.getApiUrl('update_setting');
            let payload = {
                'onesender_api_url': this.apiUrl,  
                'onesender_api_key': this.apiKey,  
                'admin_phones': this.adminPhones,  
                'nonce': window.__OSSL.nonce,  
            };
            this.ajaxPost(ajaxurl, payload, function (res) {
                this.saveLoading = false;
                console.log(res);
                if (res.success) {
                    this.loading = false;
                    this.adminPhones = res.data.setting.admin_phones;
                }
            }.bind(this));
        },

        btnActionTest() {
            console.log("Test");
            this.testLoading = true;
            let ajaxurl = this.getApiUrl('test_sender');
            this.ajaxPost(ajaxurl, { nonce: window.__OSSL.nonce }, function (res) {
                this.testLoading = false;
                console.log(res);
                if (!res.success) {
                    alert(res.message);
                } 
            }.bind(this));
        },
    },

    computed: {
        btnTestLabel() {
            return this.testLoading ? '<i class="dashicons dashicons-update rotate"></i> Loading' : 'Test kirim pesan';
        },
        btnSaveLabel() {
            return this.saveLoading ? '<i class="dashicons dashicons-update rotate"></i> Loading' : 'Simpan pengaturan';
        }
    },

    created() {
        this.loadData();
    }
});

app.mount('#ossl-app');