<?php

namespace OneSender\Salesloo;

defined('ABSPATH') or die('No direct access allowed to this file');

use Ds\Map;

class AdminMenu {

    const PLUGIN_PATH = 'onesender-salesloo/onesender-salesloo.php';

    public static function init() {
        $class = new static();
    }

    public function __construct() {
        add_action( 'admin_menu', array( $this, 'add_menu_page' ) );
        add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ) );
        add_filter( 'plugin_action_links', array($this, 'plugin_menu_links' ), 15, 2 );

        add_action('init', function() {
        });
    }

    public function add_menu_page() {
        add_menu_page(
            'OneSender',
            'OneSender',
            'manage_options',
            'onesender_salesloo',
            array( $this, 'render_dashboard' ),
            OSSL_URL . 'assets/img/menu-logo.svg',
            3
        );
    }

    public function render_dashboard() {
        ob_start();

        ?>
        <style>
            @keyframes berputar {
                from {
                    -ms-transform: rotate(0deg);
                    -moz-transform: rotate(0deg);
                    -webkit-transform: rotate(0deg);
                    -o-transform: rotate(0deg);
                    transform: rotate(0deg);
                }
                to {
                    -ms-transform: rotate(360deg);
                    -moz-transform: rotate(360deg);
                    -webkit-transform: rotate(360deg);
                    -o-transform: rotate(360deg);
                    transform: rotate(360deg);
                }
            }

            .toplevel_page_onesender_salesloo .notice {
                display: none !important;
            }
            .osapp {
                padding-top: 1rem;
            }
            .osapp h1 {
                font-size: 23px;
                font-weight: 400;
                margin: 0;
                padding: 9px 0 4px;
                line-height: 1.3;
            }

            .osapp .action-bar button {
                margin-right: 1rem;
                position: relative;
            }

            .osapp .action-bar button .dashicons {
                position: relative;
                width: 20px;
                height: 20px;
            }

            .osapp .action-bar button .dashicons::before {
                position: absolute;
                top: 4px;
                left: 0px;
                animation: berputar 1s linear infinite;
            }

            
            .osapp[v-cloak] h1, 
            .osapp[v-cloak] h3, 
            .osapp[v-cloak] .form-table th,
            .osapp[v-cloak] .form-table td 
            {
                position: relative;
                visibility: hidden;
            }

            .osapp[v-cloak] h1::after {
                content: '';
                position: absolute;
                border-radius: 3px;
                height: 28px;
                width: 250px;
                background-color: #d4d4d4;
                left: 0;
                top: 8px;
                visibility: visible;
            }
            .osapp[v-cloak] h3::after {
                content: '';
                position: absolute;
                border-radius: 3px;
                height: 28px;
                width: 250px;
                background-color: #d4d4d4;
                left: 0;
                top: 2px;
                visibility: visible;
            }

            .osapp[v-cloak] .form-table th::after {
                content: '';
                position: absolute;
                border-radius: 3px;
                height: 32px;
                width: 150px;
                background-color: #d4d4d4;
                left: 0;
                top: -4px;
                top: 18px;
                visibility: visible;
            }

            .osapp[v-cloak] .form-table td::after {
                content: '';
                position: absolute;
                border-radius: 3px;
                height: 32px;
                width: 350px;
                background-color: #d4d4d4;
                left: 10px;
                top: 16px;
                visibility: visible;
            }

            .osapp[v-cloak] .action-bar, .osapp[v-cloak] input {
                display: none;
            }

            .osapp th{
                font-weight: 400;
            }
        </style>
        <div id="ossl-app" class="osapp v-cloak" v-cloak>
            <h1>Pengaturan OneSender</h1>
            
            
            <h3>Setting API</h3>

            <table class="form-table">
                <tbody>
                    <tr>
                        <th scope="row"><label for="onesender-url">Link API WhatsApp</label></th>
                        <td><input name="onesender_url" type="text" id="onesender-url" class="regular-text"
                                v-model="apiUrl"></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="onesender-key">Api Key</label></th>
                        <td><input name="onesender_key" type="password" id="onesender-key" class="regular-text"
                                v-model="apiKey"></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="admin-phones">Admin phones</label></th>
                        <td><input name="admin_phones" type="text" id="admin-phones" class="regular-text"
                                v-model="adminPhones"></td>
                    </tr>
                </tbody>
            </table>


            <h3>Info sender</h3>

            <table class="form-table">
                <tbody>
                    <tr>
                        <th scope="row"><label for="onesender-url">Status</label></th>
                        <td>
                            <span class="os-pill" :class="{'success': senderStatus == 'online', 'danger': senderStatus !== 'online'}">{{senderStatus}}</span>
                            
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="onesender-key">Pause</label></th>
                        <td>
                            <span class="os-pill danger" v-if="senderPause">Pause</span>
                            <span class="os-pill success" v-if="!senderPause">Running</span>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="onesender-key">Nomor</label></th>
                        <td>{{senderPhone}}</td>
                    </tr>

                </tbody>
            </table>

            <p style="margin-bottom: 32px">Pengaturan konten pesan <a href="<?php echo admin_url('admin.php?page=salesloo-settings&tab=notification&section=onesender'); ?>">klik di sini</a>.
            
            <div class="action-bar">
                <button id="btn-save" class="button button-primary" v-on:click.prevent="btnSaveSetting"
                    v-html="btnSaveLabel"></button>
                <button id="btn-test-wa" class="button" v-on:click.prevent="btnActionTest"
                    v-html="btnTestLabel"></button>
            </div>
        </div><!--osapp-->
        <?php

        echo ob_get_clean();
    }
    public function admin_scripts( $hook ) {
        $pages = new Map(['toplevel_page_onesender_salesloo', 'onesender_page_onesender_salesloo_history']);

        if ( ! $pages->hasValue( $hook ) ) return;
        $hook = str_replace( ['toplevel_page_', 'onesender_page_'], '', $hook );

        wp_enqueue_style( 'ossl-dashboard', OSSL_URL . 'assets/css/dashboard.css', array(), OSSL_VERSION );

        if ($hook == 'onesender_salesloo') {
            wp_enqueue_script( 'ossl-vue', OSSL_URL . 'assets/js/vue.js', array(), OSSL_VERSION, true );
            wp_enqueue_script( 'ossl-dashboard', OSSL_URL . 'assets/js/dashboard.js', array(), OSSL_VERSION, true );
            wp_localize_script( 'ossl-dashboard', '__OSSL',
                array(
                        'ajaxurl' 	=> admin_url( 'admin-ajax.php' ),
                        'prefix' 	=> 'ossl_',
                        'hook' 		=> $hook,
                        'version' 	=> OSSL_VERSION,
                        'nonce' 	=> wp_create_nonce()
                )
            );
        } elseif ($hook == 'onesender_salesloo_history') {
            wp_enqueue_script( 'ossl-history', OSSL_URL . 'assets/js/history.js', array(), OSSL_VERSION, true );
            wp_localize_script( 'ossl-history', '__OSSL',
                array(
                        'ajaxurl' 	=> admin_url( 'admin-ajax.php' ),
                        'prefix' 	=> 'ossl_',
                        'hook' 		=> $hook,
                        'version' 	=> OSSL_VERSION,
                        'nonce' 	=> wp_create_nonce()
                )
            );
        }

    }

    public function render_history_page() {
        $args = array(
            'version' => 1
        );

        load_template( OSSL_PATH . '/inc/templates/history.php', true, $args );
    }

    public function plugin_menu_links( $options_links, $starter_file ) {
        if ( self::PLUGIN_PATH == $starter_file ) {
            $base_links['menu_link'] = sprintf('<a href="%s">Setting</a>', admin_url( 'admin.php?page=onesender_salesloo' ) );
            $options_links = array_merge($base_links, $options_links);
            $update_link = sprintf('<a href="%s" style="color: #d63638;">Check update</a>', admin_url( 'plugins.php?force_update=true' ) );
            $options_links['force_update'] = $update_link;
        }
        return $options_links;
    }

}
