<?php

namespace OneSender\Salesloo;
defined('ABSPATH') or die('No direct access allowed to this file');

class Ajax {
    public static function init() {
        $class = new static();
    }

    public function __construct() {
        add_action( 'wp_ajax_ossl_get_setting', array($this, 'get_settings') );
        add_action( 'wp_ajax_ossl_update_setting', array($this, 'update_settings') );
        add_action( 'wp_ajax_ossl_test_sender', array($this, 'test_sender') );

        add_action( 'wp_ajax_nopriv_ossl_get_setting', array($this, 'unauthorized') );
        add_action( 'wp_ajax_nopriv_ossl_update_setting', array($this, 'unauthorized') );
        add_action( 'wp_ajax_nopriv_ossl_test_sender', array($this, 'unauthorized') );
    }
    
    public function get_settings() {
        global $current_user;

        if (!isset($current_user->allcaps['administrator'])) {
            return wp_send_json([
                'success' => false,
                'message' => 'Unauthorized access',
            ]);
        }

        $class = new Ajax\GetSettings();
        return $class->response();
    }

    public function update_settings() {
        global $current_user;

        if (!isset($current_user->allcaps['administrator'])) {
            return wp_send_json([
                'success' => false,
                'message' => 'Unauthorized access',
            ]);
        }

        $class = new Ajax\UpdateSettings();
        return $class->response();
    }

    public function test_sender() {
        global $current_user;

        if (!isset($current_user->allcaps['administrator'])) {
            return wp_send_json([
                'success' => false,
                'message' => 'Unauthorized access',
            ]);
        }

        $class = new Ajax\TestSender();
        return $class->response();
    }

    public function unauthorized() {
        return wp_send_json([
            'success' => false,
            'message' => 'Unauthorized. Anda tidak memiliki akses untuk membuka halaman ini.',
            'errors' => [],
        ]);
    }
}