<?php

namespace OneSender\Salesloo\Ajax;

defined('ABSPATH') or die('No direct access allowed to this file');

use OneSender\Salesloo\Utils;
use Valitron\Validator;

class GetSettings {

	public function response() {
		global $current_user;
        Utils::cors();

		if ( !isset( $current_user->allcaps['administrator'] ) ) {
            return wp_send_json( array(
                'success' => false,
                'message' => 'Unauthorized access',
            ) );
        }
        
        $output = array(
            'success'               => true,
            'message'               => 'Get settings',
            'data'                  => array(
                'setting'           => self::get_res_settings(),
                'sender'            => self::get_sender()
            ),
        );

        return wp_send_json( $output );
	}

    public static function get_sender() {
        $endpoint = str_replace( 'v1/messages', 'feeds', Utils::get_api_url() );

        $token = salesloo_get_option('onesender_apikey');

        $headers = array(
            'Authorization' => 'Bearer ' . $token
        );

        $response = wp_remote_get($endpoint, array(
            'headers' => $headers
        ));

        if ( is_wp_error( $response ) || !isset($response['body']) ) {
            return array(
                'success' => false,
                'sender_number' => '',
                'status' => 'not available',
                'pause' => false,
            );
        } 
        
		$res_array = json_decode( $response['body'], true );
		if (json_last_error() !== JSON_ERROR_NONE) {
            return array(
                    'success' => false,
                    'sender_number' => '',
                    'status' => 'not available',
                    'pause' => false,
                );
		}

        return array(
            'success'       => isset( $res_array['data']['phone'] ),
            'sender_number' => $res_array['data']['phone'] ?? '',
            'status'        => $res_array['data']['status'] ?? 'not available',
            'pause'         => boolval( $res_array['data']['sender_pause'] ?? false ),
        );
    }

    public static function get_res_settings() {
        $url = strval( Utils::get_api_url() );
		$key = strval( salesloo_get_option('onesender_apikey') );
		$admin_phones = strval( salesloo_get_option('onesender_admins_phone') );

        $output = array(
            'onesender_api_url' => $url,
            'onesender_api_key' => $key,
            'admin_phones'      => $admin_phones,
        );

        return $output;
    }
}
