<?php

namespace OneSender\Salesloo\Ajax;

defined('ABSPATH') or die('No direct access allowed to this file');

use Valitron\Validator;
use OneSender\Salesloo\Utils;

class TestSender {

	public function response() {
		global $current_user;
        Utils::cors();

		if ( !isset( $current_user->allcaps['administrator'] ) ) {
            return wp_send_json( array(
                'success' => false,
                'message' => 'Unauthorized access',
            ) );
        }

        $output = array(
            'success'               => false,
            'message'               => 'Test WaSender',
            'data'                  => array(),
        );

        $url    = Utils::get_api_url();
        $token  = salesloo_get_option('onesender_apikey');

        $nomor = apply_filters( 'onesender/salesloo/test_phone', '6288215511011' );

        $content = sprintf( 'Test kirim pesan integrasi Salesloo. %s. %s.', home_url(), wp_date( 'd/m/Y H:i') );
        $content = apply_filters( 'onesender/salesloo/test_message', $content );

        $message     = [
            'to'             => $nomor,
            'recipient_type' => 'individual',
            'type'           => 'text',
            'text'           => ['body' => $content],
        ];

        $headers = array( 
            'Authorization' => 'Bearer ' . $token, 
            'Content-Type' => 'application/json'
        );

        $args    = array(
            'body'          => json_encode( $message ),
            'sslverify'     => false,
            'headers'       => $headers,
            'method'        => 'POST',
            'data_format'   => 'body'
        );
        
        $response = wp_remote_post( $url, $args );

        if ( is_wp_error( $response ) ) {
            return wp_send_json( array(
                'success' => false,
                'message' => $response->get_error_message(),

            ) );
        } 
        
		if ( isset($response['body'])) {
			$res_array = json_decode( $response['body'], true );
			if (json_last_error() == JSON_ERROR_NONE) {

                $output = array(
                    'success'               => ($res_array['code'] ?? 400) === 200 ,
                    'message'               => 'Test WaSender',
                    'data'                  => $res_array
                );
			}
		}
        
        return wp_send_json( $output );
	}
}
