<?php

namespace OneSender\Salesloo\Ajax;

defined('ABSPATH') or die('No direct access allowed to this file');

use Ds\Map;
use Valitron\Validator;
use OneSender\Salesloo\Utils;

class UpdateSettings {
    public function response() {
        global $current_user;
        Utils::cors();

        if ( !isset( $current_user->allcaps['administrator'] ) ) {
            return wp_send_json( array(
                'success' => false,
                'message' => 'Unauthorized access',
            ) );
        }

        $input = Utils::request_json();

        list( $success, $errors, $input ) = $this->validate( $input );

        if ( !$success ) {
            $error_message = (new Map($errors))->map(function($key, $item) {
                if (is_array($item)) {
                    return implode('. ', $item);
                }

                return $item;
            })->toArray();


            return wp_send_json( array(
                'success'   => false,
                'message'   => trim(implode('. ', $error_message)),
                'errors'    => $errors
            ) );

        }

        $admin_phones = trim( $input['admin_phones'] ?? '' );

        if (!empty($admin_phones)) {
            $admin_phones = explode(',', $admin_phones);
            $admin_phones = array_filter(array_map('\OneSender\Salesloo\Utils::phone', $admin_phones));
            $admin_phones = implode(', ', $admin_phones);
        }

        salesloo_update_option( 'onesender_apiurl', $input['onesender_api_url']);
        salesloo_update_option( 'onesender_apikey', $input['onesender_api_key']);
        salesloo_update_option( 'onesender_admins_phone', $admin_phones);

        $output                      = array(
            'success'                => true,
            'message'                => 'Settings updated',
            'data'                   => array(
                'setting'            => GetSettings::get_res_settings()
            )
        );

        return wp_send_json( $output );
    }


    public function validate( $input ) {
        $default = array(
            'nonce'             => '',
            'onesender_api_url' => '',
            'onesender_api_key' => '',
            'admin_phones'      => ''
        );

        $input  = wp_parse_args( $input, $default );

        $input  = ( new Map( $input) )->filter(function($key, $item) use($default) {
            return isset( $default[$key] );
        } )->toArray();

        $v      = new Validator( $input );

        $v->rule( 'required', [
            'onesender_api_key',
            'onesender_api_url',
            'admin_phones',
            'nonce', 
        ] );

        $v->rule( 'url', 'onesender_api_url' );

        $input['onesender_api_url'] = Utils::auto_format_api_url( $input['onesender_api_url'] );

        return array( $v->validate(), $v->errors(), $input );
    }
}