<?php

namespace OneSender\Salesloo;
defined('ABSPATH') or die('No direct access allowed to this file');

class Hooks {
    public static function action_invoice_status( $invoice_id ): void  {

        $class = new static();
        $data = ShortcodeParser::invoice( $invoice_id );

        $admin_phones = Utils::admin_phones();
        $status = $data['invoice_status'] ?? '';

        $admin_tpl = '';
        $customer_tpl = '';
        $affiliate_tpl = '';

        $messages  = [];
        switch ($status) {
            case 'completed':
                list( $admin_tpl,  $customer_tpl,  $affiliate_tpl) = $class->completed($data);
                break;
            
            case 'unpaid':
                list( $admin_tpl,  $customer_tpl,  $affiliate_tpl) = $class->place_order($data);
                break;
        }

        if (!empty($customer_tpl)) {
            $messages[] = Utils::make_text($data['customer_phone'], $customer_tpl);
        }

        if (!empty($affiliate_tpl) && !empty($data['affiliate_phone'])) {
            $messages[] = Utils::make_text($data['affiliate_phone'], $affiliate_tpl);
        }

        if (!empty($admin_tpl) && !empty($admin_phones)) {
            foreach($admin_phones as $phone) {
                $messages[] = Utils::make_text($phone, $admin_tpl);
            }
        }
        
        do_action( 'onesender/salesloo/send_messages', $messages, $data);
    }

    public static function action_widrawal_status( $widrawal_id ): void  {
        $class = new static();
        $data = ShortcodeParser::widrawal( $widrawal_id );

        $admin_tpl = salesloo_get_option('onesender_message_commission_paid_admin', Message::get_template('admin', 'withdrawal'));
        $affiliate_tpl = salesloo_get_option('onesender_message_commission_paid_affiliate', Message::get_template('affiliate', 'completed'));

        $messages  = [];

        if (!empty($affiliate_tpl) && !empty($data['affiliate_phone'])) {
            $affiliate_tpl = Utils::parse_shortcodes($affiliate_tpl, $data);
            $messages[] = Utils::make_text($data['affiliate_phone'], $affiliate_tpl);
        }

        $admin_phones = Utils::admin_phones();
        if (!empty($admin_tpl) && !empty($admin_phones)) {
            $admin_tpl = Utils::parse_shortcodes($admin_tpl, $data);
            foreach($admin_phones as $phone) {
                $messages[] = Utils::make_text($phone, $admin_tpl);
            }
        }

        do_action( 'onesender/salesloo/send_messages', $messages, $data);
    }
    
    public static function filter_insert_notification($data) {
        $invoice_id = 0;
        $event = $data['event'] ?? null;

        if ($event === 'place_order') {
            $invoice_id = intval( $data['data']['invoice_id'] ?? 0 );
        
            if ($invoice_id > 0) {
                $invoice = salesloo_get_invoice( $invoice_id );
                if (isset($invoice->status) && $invoice->status === 'unpaid') {
                    self::action_invoice_status($invoice_id);
                }
            }
        } elseif ($event === 'commission_paid') {
            $widrawal_id = intval( $data['data']['withdrawal_id'] ?? 0 );

            if ($widrawal_id > 0) {
                self::action_widrawal_status($widrawal_id);
            }
        }

        return $data;
    }

    public function completed( $data ) {
        $input = [
            salesloo_get_option('onesender_message_invoice_completed_admin', Message::get_template('admin', 'completed')),
            salesloo_get_option('onesender_message_invoice_completed_customer', Message::get_template('customer', 'completed')),
            salesloo_get_option('onesender_message_invoice_completed_affiliate', Message::get_template('affiliate', 'completed')),
        ];
        $output = [];
        foreach($input as $key => $item) {
            $item = strval($item);
            $output[$key] = '';
            if (!empty($item)) {
                $output[$key] = Utils::parse_shortcodes($item, $data);
            } 
        }
        return $output;
    }

    public function place_order( $data ) {
        $input = [
            salesloo_get_option('onesender_message_place_order_admin', Message::get_template('admin', 'place_order')),
            salesloo_get_option('onesender_message_place_order_customer', Message::get_template('customer', 'place_order')),
            salesloo_get_option('onesender_message_place_order_affiliate', Message::get_template('affiliate', 'place_order')),
        ];
        $output = [];
        foreach($input as $key => $item) {
            $item = strval($item);
            $output[$key] = '';
            if (!empty($item)) {
                $output[$key] = Utils::parse_shortcodes($item, $data);
            } 
        }
        return $output;
    }
}