<?php

namespace OneSender\Salesloo;

defined('ABSPATH') or die('No direct access allowed to this file');

class Plugin {
    public static $instance;

    public static function instance(): Plugin {
        if (empty(self::$instance)) {
            self::$instance = new Plugin();
        }

        return self::$instance;
    }

    public function __construct() {
        AdminMenu::init();
        Ajax::init();
        Repository::init();

        if ( did_action( 'salesloo/loaded' ) ) {
            add_filter('salesloo/admin/settings/notification/sections', [$this, 'build_settings']);
        }

        if( boolval(salesloo_get_option('enable_onesender', 0) ) ) {
            add_filter('salelsoo/notification/insert/data', [Hooks::class, 'filter_insert_notification']);
            add_action('salesloo/update/invoice/status', [Hooks::class, 'action_invoice_status']);
            add_action('onesender/salesloo/send_messages', [$this, 'send_messages']);
        }
    }

    public function send_messages( $messages ): void {
        Utils::send_messages( $messages );
    }

    public function build_settings( $sections ): array {
        $setting = new SettingPage();
        $sections['onesender'] = [
                'label' => 'OneSender',
                'callback' => [$setting, 'setting']
            ];

        return $sections;
    }
}
