<?php

namespace OneSender\Salesloo;
defined('ABSPATH') or die('No direct access allowed to this file');

class SettingPage {
    private $column = 'customer';
    private $tabbing = [];

    private $shortcodes = [];
    public function __construct() {
        $tabs = [
            'customer' => __('Message for Customer', 'salesloo'),
            'affiliate' => __('Message for Affiliate', 'salesloo'),
            'admin'   => __('Message for Admin', 'salesloo')
        ];

        if (isset($_GET['column']) && isset($tabs[$_GET['column']])) {
            $this->column = sanitize_text_field($_GET['column']);
        }

        $this->shortcodes = ShortcodeParser::get_default_invoice_pairs();

        foreach ($tabs as $key => $label) {
            $url = admin_url('admin.php' . salesloo_current_query_args(['column' => $key]));
            $class = $key == $this->column ? 'current' : '';
            $this->tabbing[] = '<li><a class="' . $class . '" href="' . $url . '">' . $label . '</a></li>';
        }
  }

    public function setting() {

        $field = [
            'label' => __('Enable', 'salesloo'),
            'name' => 'enable_onesender',
            'description' => __('', 'salesloo'),
            'value' => \salesloo_get_option('enable_onesender', 1),
        ];
        \salesloo_field_toggle($field);

        echo '<div class="salesloo-field"><ul class="subsubsub">';
        echo implode(' | ', $this->tabbing);
        echo '</ul></div>';

        $this->for_admin();
        $this->for_customer();
        $this->for_affiliate();

        \salesloo_field_submit();
    }

    private function for_admin() {
        if ('admin' != $this->column) return;

        $shortcodes = $this->print_shortcode($this->shortcodes);

        \salesloo_field_textarea([
            'label'       => __('Place order', 'salesloo'),
            'name'        => 'onesender_message_place_order_admin',
            'description' => 'Message on place order event' . $shortcodes,
            'value'       => \salesloo_get_option('onesender_message_place_order_admin', Message::get_template('admin', 'place_older')),
            'style' => 'height:200px;'
        ]);

        \salesloo_field_textarea([
            'label'       => __('Completed Invoice', 'salesloo'),
            'name'        => 'onesender_message_invoice_completed_admin',
            'description' => 'Message on completed invoice event' . $shortcodes,
            'value'       => \salesloo_get_option('onesender_message_invoice_completed_admin', Message::get_template('admin', 'invoice_completed')),
            'style' => 'height:200px;'
        ]);

        $shortcodes = ShortcodeParser::get_default_widrawal_pairs();
        $shortcodes_string = $this->print_shortcode($shortcodes);
        \salesloo_field_textarea([
            'label'       => __('Commission paid', 'salesloo'),
            'name'        => 'onesender_message_commission_paid_admin',
            'description' => 'When commission paid event' . $shortcodes_string,
            'value'       => \salesloo_get_option('onesender_message_commission_paid_admin', Message::get_template('admin', 'commission_paid')),
            'style' => 'height:200px;'
        ]);
    }
    
    private function for_customer() {
        if ('customer' != $this->column) return;
        $shortcodes = $this->shortcodes;
        unset($shortcodes['affiliate_name']);
        unset($shortcodes['affiliate_email']);

        $shortcodes_string = $this->print_shortcode($shortcodes);

        \salesloo_field_textarea([
            'label'       => __('Place order', 'salesloo'),
            'name'        => 'onesender_message_place_order_customer',
            'description' => 'Message on place order event' . $shortcodes_string,
            'value'       => \salesloo_get_option('onesender_message_place_order_customer', Message::get_template('customer', 'place_older')),
            'style' => 'height:200px;'
        ]);

        \salesloo_field_textarea([
            'label'       => __('Completed Invoice', 'salesloo'),
            'name'        => 'onesender_message_invoice_completed_customer',
            'description' => 'Message on completed invoice event' . $shortcodes_string,
            'value'       => \salesloo_get_option('onesender_message_invoice_completed_customer', Message::get_template('customer', 'invoice_completed')),
            'style' => 'height:200px;'
        ]);
    }

    private function for_affiliate() {
        if ('affiliate' != $this->column) return;

        $shortcodes = $this->shortcodes;
        $shortcodes_string = $this->print_shortcode($shortcodes);

        $shortcodes = [
            'site'           => __('Site name', 'salesloo'),
            'customer_name'  => __('Customer Name', 'salesloo'),
            'customer_email' => __('Customer Email', 'salesloo'),
            'number'         => __('Invoice number', 'salesloo'),
            'payment_method' => __('Payment Method', 'salesloo'),
            'products'       => __('Purchased Products', 'salesloo'),
            'due_date'       => __('Due date Invoice', 'salesloo'),
            'invoice_url'    => __('Payment link', 'salesloo'),
        ];

        \salesloo_field_textarea([
            'label'       => __('Place order', 'salesloo'),
            'name'        => 'onesender_message_place_order_affiliate',
            'description' => 'Message on place order event' . $shortcodes_string,
            'value'       => \salesloo_get_option('onesender_message_place_order_affiliate', Message::get_template('affiliate', 'place_older')),
            'style' => 'height:200px;'
        ]);

        $shortcodes['commission']     = __('Commission', 'salesloo');

        \salesloo_field_textarea([
            'label'       => __('Completed Invoice', 'salesloo'),
            'name'        => 'onesender_message_invoice_completed_affiliate',
            'description' => 'Message on completed invoice event' . $shortcodes_string,
            'value'       => \salesloo_get_option('onesender_message_invoice_completed_affiliate', Message::get_template('affiliate', 'invoice_completed')),
            'style' => 'height:200px;'
        ]);

        $shortcodes = ShortcodeParser::get_default_widrawal_pairs();
        $shortcodes_string = $this->print_shortcode($shortcodes);
        \salesloo_field_textarea([
            'label'       => __('Commission paid', 'salesloo'),
            'name'        => 'onesender_message_commission_paid_affiliate',
            'description' => 'When commission paid event' . $shortcodes_string,
            'value'       => \salesloo_get_option('onesender_message_commission_paid_affiliate', Message::get_template('affiliate', 'commission_paid')),
            'style' => 'height:200px;'
        ]);
    }

    private function print_shortcode($tags) {
        ob_start();
        echo '<br/>';
        echo 'print shortcode<br/>';
        foreach ($tags as $tag => $note) {
            echo '<strong>{' . $tag . '}</strong> => ' . $note . '<br/>';
        }
        $content = ob_get_contents();
        ob_end_clean();

        return $content;
    }
}