<?php

namespace OneSender\Salesloo;
defined('ABSPATH') or die('No direct access allowed to this file');

class ShortcodeParser {

    public static function invoice( $invoice_id ): array {

        $output = self::get_default_invoice();

        $invoice = salesloo_get_invoice( $invoice_id );
        if (!$invoice) {
            return $output;
        }

        $customer_id = intval($invoice->user_id);
        $output['invoice_id'] = $invoice->ID;
        $output['customer_phone'] = '';
        $output['affiliate_phone'] = '';

        $customer = get_user_by( 'ID', $customer_id );
        if ($customer->ID > 0) {
            $output['customer_name'] = $customer->data->display_name ?? '';
            $output['customer_email'] = $customer->data->user_email ?? '';
            
            $phone = Utils::phone( get_user_meta( $customer_id, 'phone', true ) );
            $output['customer_phone'] = strval($phone);
        }

        /* affiliate */
        $affiliate_username = salesloo_get_current_affiliate_cookie();
        if ($affiliate_username) {
            $affiliate = get_user_by('login', $affiliate_username);
            $output['affiliate_name'] = $affiliate->data->display_name ?? '';
            $output['affiliate_email'] = $affiliate->data->user_email ?? '';
            $phone = Utils::phone( get_user_meta( ($affiliate->ID ?? 0), 'phone', true ) );
            $output['affiliate_phone'] = strval($phone);
        } else {
            $affiliate_data = Utils::get_affiliate_data_from_invoice($invoice->ID ?? 0);
            $output = array_merge( $output, $affiliate_data );
        }

        $payments = [
            'bacs' => __('Direct Bank Transfer', 'salesloo'),
            'paypal' => __('Paypal', 'salesloo'),
        ];

        $payment = $invoice->payment_method;
        $output['payment_method'] = $payments[$payment] ?? '';
        
        /* summary */
        $summary = $invoice->summary;
        $default_product = [
            'label' => '',
            'value' => 0,
            'print' => '',
            'price' => [
              'value' => 0,
              'print' => '',
            ],
            'commission' => [
              'value' => 0,
              'print' => '0',
            ],
        ];

        /* $product = $summary['products'][1] ?? $default_product; */
        $product = $default_product;
        if ( is_array( $summary['products'] ) && count( $summary['products'] ) > 0 ) {
            $pkey = array_key_first( $summary['products'] );

            if (isset($summary['products'][$pkey])) {
                $product = $summary['products'][$pkey];
            }
        }
        
        $output['product_name'] = $product['label'];
        $output['product_price'] = Utils::rupiah($product['value']);

        $output['total'] = Utils::rupiah($invoice->total ?? 0);
        $output['commission'] = Utils::rupiah($product['commission']['value']);

        $duedate = $invoice->due_date_at ?? wp_date('Y-m-d H:i:s');
        $dateTime = new \DateTime($duedate);
        $output['due_date'] = $dateTime->format('d/m/Y');

        $output['number'] = salesloo_generate_invoice_format($invoice->ID);

        $encoded_invoice_id = salesloo_encrypt($invoice->ID);
        $output['payment_url'] = salesloo_url_payment($encoded_invoice_id);

        $output['invoice_status'] = $invoice->status ?? '';

        return apply_filters( 'onesender/salesloo/invoice_data', $output );
    }

    public static function get_default_invoice_pairs(): array {
        $shortcodes = [
            'site'           => __('Site name', 'salesloo'),
            'customer_name'  => __('Customer Name', 'salesloo'),
            'customer_email' => __('Customer Email', 'salesloo'),
            'customer_phone' => __('Customer phone', 'salesloo'),
            'number'         => __('Invoice number', 'salesloo'),
            'total'          => __('Invoice total', 'salesloo'),
            'payment_method' => __('Payment Method', 'salesloo'),
            'product_name'   => __('Product Name', 'salesloo'),
            'product_price'  => __('Product Price', 'salesloo'),
            'due_date'       => __('Due date Invoice', 'salesloo'),
            'invoice_id'     => __('Invoice ID', 'salesloo'),
            'payment_url'    => __('Invoice link', 'salesloo'),
            'affiliate_name' => __('Affiliate Name', 'salesloo'),
            'affiliate_email'=> __('Affiliate Email', 'salesloo'),
            'affiliate_phone'=> __('Affiliate phone', 'salesloo'),
            'commission'     => __('Commission', 'salesloo'),
        ];

        return apply_filters('onesender/salesloo/invoice/shortcode_info', $shortcodes);
    }

    public static function get_default_invoice(): array {
        $output = array_fill_keys(array_keys(self::get_default_invoice_pairs()), '');

        $output['site'] = get_bloginfo('name');

        return $output;
    }


    public static function widrawal( $widrawal_id ): array {
        $output = self::get_default_widrawal();

        global $wpdb;

        $query = $wpdb->prepare("
            SELECT
                withdrawal.user_id,
                withdrawal.amount,
                withdrawal.method,
                withdrawal.note,
                withdrawal.proof_of_payment,
                users.display_name,
                users.user_email
            FROM
                {$wpdb->prefix}salesloo_commission_withdrawal AS withdrawal
            LEFT JOIN
                {$wpdb->users} AS users
            ON
                users.ID = withdrawal.user_id
            WHERE
                withdrawal.ID = %d
        ", 1);

        $result = $wpdb->get_row($query, ARRAY_A);

        if (!$result) {
            return $output;
        }
        
        $affiliate = get_user_by( 'ID', $result['user_id'] );

        if ($affiliate->ID > 0) {
            $phone = Utils::phone( get_user_meta( $affiliate->ID, 'phone', true ) );
            $output['affiliate_phone'] = strval($phone);
        }

        $methods = [
                'paypal' => 'Paypal',
                'bank_transfer' => 'Bank Transfer',
            ];

        $method = $result['method'] ?? '';

        $output['affiliate_name'] = $result['display_name'];
        $output['affiliate_email'] = $result['user_email'];
        $output['note'] = $result['note'] ?? '';
        $output['payment_method'] = $methods[$method] ?? '';
        $output['commission'] = Utils::rupiah($result['amount']);

        $media_id = intval($result['proof_of_payment']);
        if ($media_id > 0) {

            $upload     = wp_get_upload_dir();
            $path_meta  = (string) get_post_meta( $media_id, '_wp_attached_file', true );

            if (!empty($path_meta)) {
                $path = $upload['basedir'] .'/'. $path_meta;
                if (file_exists($path)) {
                    $output['proof'] = $upload['baseurl'] .'/'. $path_meta;
                }
            }
        }

        return $output;
    }

    public static function get_default_widrawal(): array {
        $output = array_fill_keys(array_keys(self::get_default_widrawal_pairs()), '');

        $output['site'] = get_bloginfo('name');


        return $output;
    }

    public static function get_default_widrawal_pairs(): array {
        $shortcodes = [
            'site'           => __('Site name', 'salesloo'),
            'payment_method' => __('Payment Method', 'salesloo'),
            'affiliate_name' => __('Affiliate Name', 'salesloo'),
            'affiliate_email'=> __('Affiliate Email', 'salesloo'),
            'affiliate_phone'=> __('Affiliate phone', 'salesloo'),
            'commission'     => __('Commission', 'salesloo'),
            'note'           => __('Note', 'salesloo'),
            'proof'          => __('Proof', 'salesloo'),
        ];

        return apply_filters('onesender/salesloo/invoice/shortcode_info', $shortcodes);
    }

}