<?php
/**
 * Plugin Name:     Onesender Salesloo
 * Plugin URI:      https://onesender.net
 * Description:     Integrasi OneSender ke Salesloo
 * Author:          M Ali
 * Author URI:      https://onesender.net
 * Text Domain:     onesender-salesloo
 * Domain Path:     /languages
 * Version:         0.9.2
 *
 * @package         Onesender_Salesloo
 */
defined( 'ABSPATH' ) || die('.');

define( 'OSSL_VERSION',     '0.9.2' );
define( 'OSSL_BUILD_VERSION', 902 );
define( 'OSSL_TABLE_VERSION', 1 );
define( 'OSSL_PATH',        plugin_dir_path( __FILE__ ) );
define( 'OSSL_URL',         plugin_dir_url( __FILE__ ) );
define( 'OSSL_PLUGIN_FILE', __FILE__ );

require_once OSSL_PATH . '/inc/bootstrap.php';

function ossl_check_system_requirements(): array {
    global $wp_version;

    $valid = true;
    $errors = array();

    if( version_compare(PHP_VERSION, '7.4.0') <= 0 ) {
        $valid = false;
        $errors[] = 'Versi PHP minimal 7.4';
    }

    if( version_compare($wp_version, '5.9.0') <= 0 ) {
        $valid = false;
        $errors[] = 'Versi WordPress minimal 5.9';
    } 

    return array($valid, $errors);
}

list( $valid, $check_errors ) = ossl_check_system_requirements();

if ( !$valid ) {
    add_action('admin_notices', function() use($check_errors) {
        echo '<div class="notice notice-error" style="padding-top: 15px;">';
        echo '<strong>Plugin OneSender Salesloo error: </strong>';
        echo '<ul>';
        foreach($check_errors as $entry) {
            echo '<li>'. $entry .'</li>';
        }
        echo '</ul>';
        echo '</div>';
    });
} else {
    $active_plugins = get_option( 'active_plugins' );

    if ( !in_array( 'salesloo/salesloo.php', $active_plugins ) ) {
        add_action('admin_notices', function() {
            echo '<div class="notice notice-error" style="padding-top: 15px;">';
            echo '<strong>Silahkan install dan aktifkan plugin Salesloo</strong>';
            echo '<br><br></div>';
        });
    }
}

register_activation_hook( __FILE__, function() {
    require_once OSSL_PATH . 'install.php';
    ossl_install();
});
